package com.ejie.ab04b.control;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.dom.ElementNSImpl;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.constantes.ConstantesDokusi;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.EstadosTareas;
import com.ejie.ab04b.constantes.TipoCambio;
import com.ejie.ab04b.constantes.TipoExpedienteFolderEnum;
import com.ejie.ab04b.constantes.TipoTareaFlujo;
import com.ejie.ab04b.constantes.TipoTramiteFlujo;
import com.ejie.ab04b.dao.temp.DocumentosAperturasTempDao;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.exception.Mensaje;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.EstudioDocAperturas;
import com.ejie.ab04b.model.Folder;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.ab04b.model.RequerimientoAperturas;
import com.ejie.ab04b.model.Tablones;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TareaErronea;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.ab04b.model.VosalanOs4Os6;
import com.ejie.ab04b.model.pps.PPSReturnInfo;
import com.ejie.ab04b.model.toolbar.Boton;
import com.ejie.ab04b.model.toolbar.Botonera;
import com.ejie.ab04b.service.ComunicacionAperturaService;
import com.ejie.ab04b.service.CoordinadorObraService;
import com.ejie.ab04b.service.DatosAvisoService;
import com.ejie.ab04b.service.DatosNotificacionService;
import com.ejie.ab04b.service.DocumentoAperturasService;
import com.ejie.ab04b.service.EstudioDocAperturasService;
import com.ejie.ab04b.service.FolderService;
import com.ejie.ab04b.service.GeneracionPDFCartaAperturaService;
import com.ejie.ab04b.service.GeneracionPDFComunicacionOS2OS3Service;
import com.ejie.ab04b.service.GeneracionPDFComunicacionOS2Service;
import com.ejie.ab04b.service.GeneracionPDFSubsanacionService;
import com.ejie.ab04b.service.HistCambiosAperturasService;
import com.ejie.ab04b.service.RequerimientoAperturasService;
import com.ejie.ab04b.service.TablonesService;
import com.ejie.ab04b.service.TareaAperturasService;
import com.ejie.ab04b.service.TareaErroneaService;
import com.ejie.ab04b.service.TramiteAperturasService;
import com.ejie.ab04b.service.VosalanOs4Os6Service;
import com.ejie.ab04b.service.dokusi.DokusiService;
import com.ejie.ab04b.service.pif.PifService;
import com.ejie.ab04b.service.platea.GatService;
import com.ejie.ab04b.service.platea.PPSAperturasService;
import com.ejie.ab04b.service.platea.PPSAportacionService;
import com.ejie.ab04b.service.platea.PlateaTramitacionService;
import com.ejie.ab04b.service.platea.ReeService;
import com.ejie.ab04b.service.svt.SvtService;
import com.ejie.ab04b.service.tramitacion.TramitacionAperturasService;
import com.ejie.ab04b.service.validation.ValidadorBotonera;
import com.ejie.ab04b.util.DatosNavegacion;
import com.ejie.ab04b.util.HistCambiosAperturasUtil;
import com.ejie.ab04b.util.ManejoSesion;
import com.ejie.ab04b.util.PPSUtils;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.ValidadorNifCifNie;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.validation.AbstractValidator.Oper;
import com.ejie.ab04b.validation.ComunicacionAperturaValidator;
import com.ejie.ct.xml.DocumentStorageInfo;
import com.ejie.ct.xml.FolderDoc;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.ctfm.xml.ContextSubmission;
import com.ejie.foldermanagement.xml.RequestReturn;
import com.ejie.t65.jaxb.beans.fsd.T65BDocumentIDType;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.rup.jqgrid.filter.model.Filter;
import com.ejie.x38.rup.jqgrid.filter.service.FilterService;

/**
 * Ab04b56s00Controller generated by UDA, 26-dic-2016 13:08:27.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/comunicacionApertura")
public class ComunicacionAperturaController {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ComunicacionAperturaController.class);

	private static final int NUMEXP_LPAD_SIZE = 5;
	private static final String NUMEXP_LPAD_CHAR = "0";
	// Tiempo de espera mínimo para mostrar "Reabir" cuando estado='S'
	private static final long MIN_WAIT_REOPEN = 5L * 60 * 1000;

	public static final String ATTR_NAME_COMUNICAPERTURA_FILTER = "comunicAperturasFiltroModel";
	public static final String ATTR_NAME_COMUNICAPERTURA_DETALLE = "apertura";
	public static final String ATTR_NAME_COMUNICAPERTURA_LISTA_APERTURAS = "listadoAperturas";
	public static final String ATTR_NAME_COMUNICAPERTURA_NUM_APERTURAS = "numAperturas";
	public static final String ATTR_NAME_COMUNICAPERTURA_TAREA = "tareaAperturas";
	public static final String ATTR_NAME_COMUNICAPERTURA_ESTUDIO = "estudio";
	public static final String ATTR_NAME_COMUNICAPERTURA_REQUERIMIENTO = "requerimiento";
	public static final String ATTR_NAME_COMUNICAPERTURA_DESC_OTROS_ES = "descOtrosEs";
	public static final String ATTR_NAME_COMUNICAPERTURA_DESC_OTROS_EU = "descOtrosEu";
	public static final String ATTR_NAME_COMUNICAPERTURA_LISTA_MOTIVOS_REQ = "listaMotivosReq";
	public static final String ATTR_NAME_COMUNICAPERTURA_TAB_DEFECTO = "tabActiva";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_TRAMITACION = "toolbarTramitacion";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_PROC_ALMAC = "toolbarProcAlmac";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_EMPRESA = "toolbarDatosEmpresa";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_CENTRO = "toolbarDatosCentro";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_OBRA = "toolbarDatosObra";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_NOTIFICACION = "toolbarNotificacion";
	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DOCUMENTOS_REG = "toolbarDocumentosReg";

	public static final String ATTR_NAME_COMUNICAPERTURA_TOOLBAR_ESTADO = "toolbarEstado";
	public static final String ATTR_NAME_COMUNICAPERTURA_CERRAR_EXPEDIENTE = "cerrarExpediente";
	public static final String ATTR_NAME_COMUNICAPERTURA_CREAR_ESTUDIO = "crearEstudio";
	public static final String ATTR_NAME_COMUNICAPERTURA_ABRIR_EXPEDIENTE = "abrirExpediente";
	public static final String ATTR_NAME_COMUNICAPERTURA_VOLVER = "volver";

	public static final Integer TAB_DETALLE_NOTIFICACION = 0;
	public static final Integer TAB_DETALLE_EMPRESA = 1;
	public static final Integer TAB_DETALLE_CENTRO = 2;
	public static final Integer TAB_DETALLE_PRODUCCION_ALMACENAMIENTO = 3;
	public static final Integer TAB_DETALLE_OBRA = 4;
	public static final Integer TAB_DETALLE_PROYECTISTAS = 5;
	public static final Integer TAB_DETALLE_COORDINADORES = 6;
	public static final Integer TAB_DETALLE_DOCUMENTOS_OBRA = 7;
	public static final Integer TAB_DETALLE_DOCUMENTOS_CENTRO = 4;
	public static final Integer TAB_DETALLE_TRAMITACION_OBRA = 8;
	public static final Integer TAB_DETALLE_TRAMITACION_CENTRO = 5;
	public static final Integer TAB_DETALLE_HISTORICO_OBRA = 9;
	public static final Integer TAB_DETALLE_HISTORICO_CENTRO = 6;
	public static final Integer TAB_DETALLE_DEFECTO = ComunicacionAperturaController.TAB_DETALLE_NOTIFICACION;

	public static final String ATTR_NAME_ESTADO_VISITA_OSALAN = "estadoVisitaOsalan";
	public static final String ATTR_NAME_VOSALANOS4OS6_FILTER = "vosalanOs4Os6FiltroModel";

	public static final String ATTR_NAME_MODO_ACCESO = "modoAcceso";
	public static final String ATTR_NAME_MODO_ACCESO_ANTERIOR = "modoAccesoAnterior";
	public static final String ATTR_NAME_BORRAR = "borrar";

	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	@Autowired()
	private ComunicacionAperturaService comunicAperturaService;
	@Autowired()
	private TareaAperturasService tareaAperturaService;
	// @Autowired()
	// private TramiteService tramiteService;
	@Autowired()
	private TramiteAperturasService tramiteAperturaService;
	@Autowired()
	private DocumentoAperturasService documentoAperturaService;
	@Autowired()
	private DokusiService dokusiService;
	@Autowired()
	private DocumentosAperturasTempDao documentosAperturasTempDao;
	@Autowired()
	private EstudioDocAperturasService estudioDocAperturasService;
	@Autowired()
	private RequerimientoAperturasService requerimientoAperturasService;
	@Autowired()
	private DatosNotificacionService datosNotificacionService;

	@Autowired()
	private FilterService filterService;

	@Autowired()
	private FolderService folderService;
	@Autowired()
	private PPSAperturasService ppsAperturasService;

	@Autowired()
	private PPSAportacionService ppsAportacionService;

	@Autowired()
	private ComunicacionAperturaValidator comunicacionAperturaValidator;
	@Autowired()
	private ValidadorBotonera validadorBotonera;

	@Autowired()
	private TramitacionAperturasService tramitacionAperturasService;

	@Autowired()
	private HistCambiosAperturasService histCambiosAperturasService;

	@Autowired()
	private DatosAvisoService datosAvisoService;

	@Autowired()
	private PifService pifService;

	@Autowired()
	private PlateaTramitacionService plateaTramitacionService;

	@Autowired()
	private TablonesService tablonesService;

	@Autowired()
	private CoordinadorObraService coordinadorObra;

	@Autowired()
	private VosalanOs4Os6Service vosalanOs4Os6Service;

	@Autowired()
	private GeneracionPDFCartaAperturaService generacionPDFCartaAperturaService;

	@Autowired()
	private GeneracionPDFComunicacionOS2Service generacionPDFComunicacionOS2Service;

	@Autowired()
	private GeneracionPDFComunicacionOS2OS3Service generacionPDFComunicacionOS2OS3Service;

	@Autowired()
	private GatService gatService;

	@Autowired()
	private ReeService reeService;

	@Autowired()
	private SvtService svtService;

	@Autowired()
	private TareaErroneaService tareaErroneaService;

	@Autowired()
	private GeneracionPDFSubsanacionService generacionPDFSubsanacionService;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 * binder WebDataBinder
	 * 
	 * @param binder
	 *            the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * terape String anoape String numape Long Ab04b56s00 Objeto correspondiente
	 * al identificador indicado.
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public @ResponseBody() ComunicacionApertura get(
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) {

		ComunicacionApertura comunicApertura = new ComunicacionApertura(terape,
				anoape, numape);
		comunicApertura = this.comunicAperturaService.find(comunicApertura);
		ComunicacionAperturaController.LOGGER
				.info("[GET - findBy_PK] : Obtener Ab04b56s00 por PK");
		return comunicApertura;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * filterComunicacionApertura Ab04b56s00 Objeto que contiene los parametros
	 * de filtrado utilizados en la busqueda. List<Ab04b56s00> Lista de objetos
	 * correspondientes a la busqueda realizada.
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura the all
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() List<ComunicacionApertura> getAll(
			@ModelAttribute() ComunicacionApertura filterComunicacionApertura) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - find_ALL] : Obtener Ab04b56s00 por filtro");
		return this.comunicAperturaService.findAll(filterComunicacionApertura,
				null);
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 * filterComunicacionApertura Expediente Bean que contiene los parÃ¡metros
	 * de filtrado a emplear. jqGridRequestDto JQGridRequestDto que contiene los
	 * parÃ¡mtros de configuraciÃ³n propios del RUP_TABLE a aplicar en el
	 * filtrado. modelMap ModelMap columns String request HttpServletRequest
	 * ModelAndView
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param modelMap
	 *            the model map
	 * @param columns
	 *            the columns
	 * @param request
	 *            the request the report
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() ComunicacionApertura filterComunicacionApertura,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<ComunicacionApertura> listComunicaciones = this.comunicAperturaService
				.findAllLike(filterComunicacionApertura, jqGridRequestDto,
						false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.comunicacionesApertura"),
				columns, listComunicaciones);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * comunicApertura Ab04b56s00 Bean que contiene la informacion a modificar.
	 * Ab04b56s00 Bean resultante de la modificacion.
	 * 
	 * @param comunicApertura
	 *            the comunic apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() ComunicacionApertura edit(
			@RequestBody() ComunicacionApertura comunicApertura) {
		ComunicacionApertura comunicAperturaAux = this.comunicAperturaService
				.update(comunicApertura);
		ComunicacionAperturaController.LOGGER
				.info("[PUT] : Ab04b56s00 actualizado correctamente");
		return comunicAperturaAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * terape String anoape String numape Long ComunicacionApertura Bean
	 * eliminado.
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/{terape}/{anoape}/{numape}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() ComunicacionApertura remove(
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) {
		ComunicacionApertura comunicApertura = new ComunicacionApertura(terape,
				anoape, numape);
		this.comunicAperturaService.remove(comunicApertura);
		ComunicacionAperturaController.LOGGER
				.info("[DELETE] : comunicApertura borrado correctamente");
		return comunicApertura;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale request HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale
	 * @param request
	 *            the request the form edit
	 * @return the form edit
	 */
	@RequestMapping(value = "/filtro", method = RequestMethod.GET)
	public String getFormEdit(Model model, Locale locale,
			HttpServletRequest request) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura apertura = new ComunicacionApertura();

		Calendar c = Calendar.getInstance();
		apertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));
		apertura.setEstado056(Constantes.ESTADO_ABIERTO);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				apertura);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_VOLVER,
				false);

		// Con este parametro sabre los botones que tengo que mostrar en la
		// tabla de resultados de Aperturas de Centros de Trabajo
		if (request.getParameter("modo") != null) {
			request.getSession().setAttribute("modo",
					request.getParameter("modo"));
		}

		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR,
				null);

		return "comunicacionApertura";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale String
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale the string
	 * @return the string
	 */
	@RequestMapping(value = "/filtroCambioCoordinador", method = RequestMethod.GET)
	public String filtroCambioCoordinador(Model model, Locale locale) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura ca = new ComunicacionApertura();
		ca.setIndobra056("S");

		ca.setEstado056("A");

		Calendar c = Calendar.getInstance();
		ca.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				ca);

		model.addAttribute("cambioCoord", Constantes.VALUE_SI);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_VOLVER,
				false);

		return "comunicacionApertura";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model request HttpServletRequest locale Locale String
	 * 
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param locale
	 *            the locale the string
	 * @return the string
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public String altaPresencial(Model model, HttpServletRequest request,
			Locale locale) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");

		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(new Date());
		model.addAttribute("ano", Long.valueOf(gc.get(GregorianCalendar.YEAR)));

		model.addAttribute("delegacion",
				UtilSeguridad.getInstance().obtenerDelegacionUsuario());

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				new ComunicacionApertura());
		this.precargaCombosFiltroBusqueda(model);

		return "expedientesAlta";
	}

	/**
	 * Alta de Expediente
	 * 
	 * 
	 * @param apertura
	 *            Denuncia Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Denuncia Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura add(
			@RequestBody() ComunicacionApertura apertura) {

		ComunicacionApertura nuevaComunicacion = this.comunicAperturaService
				.altaComunicacionAperturaPresencial(apertura);

		return nuevaComunicacion;
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * comunicacionApertura ComunicacionApertura model Model String
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param model
	 *            the model the string
	 * @return the string
	 */
	@RequestMapping(value = "/abrirComunicacion", method = RequestMethod.POST)
	public @ResponseBody() String abrirComunicacion(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			Model model, HttpServletRequest request) {

		ComunicacionApertura apertura = this.comunicAperturaService
				.findConObra(comunicacionApertura);

		ComunicacionApertura ape = this.comunicAperturaService
				.findDatosRegistro(apertura);
		apertura.setDeseaRegistrar(ape.getDeseaRegistrar());
		apertura.setNumReg(ape.getNumReg());
		apertura.setFecReg(ape.getFecReg());

		List<ErrorField> errores = new ArrayList<ErrorField>();
		this.validaComunicacionAperturaPresencial(errores, apertura);

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// List<DocumentoAperturas> listaDocumentos = new
		// ArrayList<DocumentoAperturas>();
		// recoger de la tabla temporal
		DocumentoAperturas docFilter = new DocumentoAperturas();
		docFilter.setIdapetemp065(apertura.getIdape056());
		try {
			String reabrir = (String) request.getParameter("reabrir");

			List<DocumentoAperturas> listaDocumentos = this.copiarDocsR02G(
					apertura.getIdape056(), apertura.getTerape056(),
					(reabrir != null));

			ContextSubmission contextSubmission = this.ppsAperturasService
					.crearContextSubmission(apertura, listaDocumentos);

			RequestReturn requestReturn = this.ppsAperturasService
					.enviarSolicitudPresencial(contextSubmission);
			PPSReturnInfo ppsReturnInfo = PPSUtils.getInstance()
					.obtenerPPSReturnInfo(requestReturn);

			Folder folder = new Folder();
			folder.setFolderid077(ppsReturnInfo.getFolderId());
			folder.setAnoexp077(apertura.getAnoape056());
			folder.setNumexp077(apertura.getNumape056().intValue());
			folder.setTerexp077(apertura.getTerape056());
			folder.setTipexp077(TipoExpedienteFolderEnum.APERTURA
					.getIdTipoExpediente().toString());

			try {
				this.folderService.add(folder);
			} catch (Exception e) {
				this.folderService.updateFolderId(folder);
			}
			apertura.setFecpre056(new Date());
			apertura.setEstado056("S");
			this.comunicAperturaService.updateFilled(apertura);
			if ("N".equals(apertura.getIndobra056())) {
				apertura.setFecfinplazo056(apertura.getFecpre056());
				this.comunicAperturaService.updateFecFinPlazo(apertura);
			}

		} catch (Exception e) {
			this.documentoAperturaService.removeTempByIdApertura(docFilter);
			errores.add(
					new ErrorField("comunicacion.apertura", "error.apertura"));
			throw new ErrorGenericoException(errores);
		}
		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				Constantes.MODO_ACCESO_MANTENIMIENTO);

		return "ok";
	}

	/**
	 * Copiar docs R 02 G.
	 * 
	 * idApe Integer List<DocumentoAperturas>
	 * 
	 * @param idApe
	 *            the id ape the list
	 * 
	 * @param territorio
	 *            String
	 * @return the list
	 * @throws AB04BException
	 *             producida al copiar los documentos en PIF
	 */
	protected List<DocumentoAperturas> copiarDocsR02G(Long idApe,
			String territorio, boolean reabrir) throws AB04BException {
		DocumentoAperturas docFilter = new DocumentoAperturas();
		docFilter.setIdapetemp065(idApe);
		List<DocumentoAperturas> listaDocumentos = null;
		if (reabrir) {
			listaDocumentos = this.documentoAperturaService.findAll(docFilter,
					null);
		} else {
			listaDocumentos = this.documentoAperturaService
					.buscarDocumentosAperturasTempIdApe(docFilter);
		}

		for (DocumentoAperturas doc : listaDocumentos) {

			if (doc.getOidDokusi065() == null) {

				doc.setTerritorio(territorio);

				String auditUser = UtilSeguridad.getInstance().getAuditUser();

				// copiamos documento en PIF a t65e
				String destPifPath = doc.getRutaPif065().replaceAll(
						ConstantesDokusi.PIF_AB04B_FOLDER.toUpperCase(),
						ConstantesDokusi.PIF_T65E_FOLDER);

				String ruta_dokusi = pifService
						.copyDocument(doc.getRutaPif065(), destPifPath, false);
				doc.setRutaPif065(ruta_dokusi); // no se guardará en BD

				// registramos en Dokusi
				T65BDocumentIDType t65BDocumentIDType = this.dokusiService
						.almacenarDocumento(auditUser, doc);

				// anadimos a la lista temporal los OIDs registrados
				doc.setOidDokusi065(t65BDocumentIDType.getId());
				// this.documentoAperturaService.update(doc);
				this.documentosAperturasTempDao.update(doc);
			}
		}

		return listaDocumentos;
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * comunicacionApertura ComunicacionApertura request HttpServletRequest
	 * model Model String
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request
	 * @param model
	 *            the model the string
	 * @return the string
	 */
	@RequestMapping(value = "/subsanar", method = RequestMethod.POST)
	public @ResponseBody() String subsanar(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request, Model model) {

		ComunicacionApertura apertura = this.comunicAperturaService
				.findDetalle(comunicacionApertura, null, null);

		ComunicacionApertura ape = this.comunicAperturaService
				.findDatosRegistro(apertura);
		apertura.setDeseaRegistrar(ape.getDeseaRegistrar());
		apertura.setNumReg(ape.getNumReg());
		apertura.setFecReg(ape.getFecReg());

		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		List<ErrorField> errores = new ArrayList<ErrorField>();
		if (Constantes.MODO_ACCESO_SUBSANACION.equals(modoAcceso)
				&& Constantes.VALUE_NO
						.equals(comunicacionApertura.getDeseaRegistrar())) {
			if (Utilities.getInstance()
					.isEmpty(comunicacionApertura.getNumReg())) {
				errores.add(new ErrorField("aperturas.detalle.numReg",
						"validacion.obligatorio"));
			}
			if (comunicacionApertura.getFecReg() == null) {
				errores.add(new ErrorField("aperturas.detalle.fecReg",
						"validacion.obligatorio"));
			}
		}

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}
		apertura.setDeseaRegistrar(comunicacionApertura.getDeseaRegistrar());
		apertura.setNumReg(comunicacionApertura.getNumReg());
		apertura.setFecReg(comunicacionApertura.getFecReg());

		// recoger de la tabla temporal
		DocumentoAperturas docFilter = new DocumentoAperturas();
		docFilter.setIdapetemp065(apertura.getIdape056());
		try {
			List<DocumentoAperturas> listaDocumentos = this.copiarDocsR02G(
					apertura.getIdape056(), apertura.getTerape056(), false);

			ContextSubmission contextSubmission = this.ppsAportacionService
					.crearContextSubmission(false, apertura, listaDocumentos);

			this.ppsAportacionService
					.enviarAportacionPresencial(contextSubmission);

		} catch (Exception e) {
			this.documentoAperturaService.removeTempByIdApertura(docFilter);
			errores.add(
					new ErrorField("comunicacion.apertura", "error.apertura"));
			throw new ErrorGenericoException(errores);
		}

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "ok";

	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model String
	 * 
	 * @param model
	 *            the model the form edit
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");
		return "comunicacionApertura";
	}

	/**
	 * Metodo para volver al listado desde pantalla detalle.
	 * 
	 * model Model request HttpServletRequest response HttpServletResponse
	 * String
	 * 
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response the back form edit
	 * @return the back form edit
	 */
	@RequestMapping(value = "/backToMaint", method = RequestMethod.GET)
	public String getBackFormEdit(Model model, HttpServletRequest request,
			HttpServletResponse response) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - backToMaint] : expedientes");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				ManejoSesion.pasaDatosNavegacionModel(request, model,
						ComunicacionApertura.class));

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_VOLVER,
				true);

		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR,
				null);

		return "comunicacionApertura";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterComunicacionApertura ComunicacionApertura Bean que contiene los
	 * parametros de filtrado a emplear. jqGridRequestDto Dto que contiene los
	 * parametros de configuracion propios del RUP_TABLE a aplicar en el
	 * filtrado. model Model request HttpServletRequest request response
	 * HttpServletResponse JQGridResponseDto<Ab04b56s00> Dto que contiene el
	 * resultado del filtrado realizado por el componente RUP_TABLE.
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response the JQ grid response dto
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<ComunicacionApertura> filter(
			@RequestJsonBody(param = "filter") ComunicacionApertura filterComunicacionApertura,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {
		ComunicacionAperturaController.LOGGER
				.info("[POST - filter] : Obtener Ab04b56s00s");

		ComunicacionApertura filter = null;

		// Si el usuario no tiene perfil de tramitador, no se muestran las
		// aperturas que estén en proceso de alta,
		// ya que en estas sólo se puede entrar en modo alta, y sólo pueden
		// hacerlo los tramitadores.
		List<String> perfiles = UtilSeguridad.getInstance().getUserCredentials()
				.getUserProfiles();
		if (!perfiles.contains(Constantes.ROL_TRAMITADOR_ALAVA)
				&& !perfiles.contains(Constantes.ROL_TRAMITADOR_BIZKAIA)
				&& !perfiles.contains(Constantes.ROL_TRAMITADOR_GIPUZKOA)) {
			filterComunicacionApertura.setOcultarEnProcesoAlta(true);
		} else {
			filterComunicacionApertura.setOcultarEnProcesoAlta(false);
		}

		// recupera datos filtro y sobreescribe el filtro si venimos de accion
		// volver
		Object datosFiltroSesion = ManejoSesion.recuperaDatosFiltro(request,
				jqGridRequestDto, ComunicacionApertura.class);
		if (datosFiltroSesion != null) {
			filter = (ComunicacionApertura) datosFiltroSesion;
		} else {
			// en caso de no venir de volver, guarda filtro
			filter = filterComunicacionApertura;
			ManejoSesion.guardaFiltro(request, filter, jqGridRequestDto);
		}

		return this.comunicAperturaService.filter(filterComunicacionApertura,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * filterComunicacionApertura ComunicacionApertura Bean que contiene los
	 * parametros de filtrado a emplear. searchComunicacionApertura
	 * ComunicacionApertura Bean que contiene los parametros de busqueda a
	 * emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en la búsqueda. TableRowDto
	 * <Ab04b56s00> Dto que contiene el resultado de la busqueda realizada por
	 * el componente RUP_TABLE.
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param searchComunicacionApertura
	 *            the search comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto the list
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody() List<TableRowDto<ComunicacionApertura>> search(
			@RequestJsonBody(param = "filter") ComunicacionApertura filterComunicacionApertura,
			@RequestJsonBody(param = "search") ComunicacionApertura searchComunicacionApertura,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ComunicacionAperturaController.LOGGER
				.info("[POST - search] : Buscar Ab04b56s00s");
		return this.comunicAperturaService.search(filterComunicacionApertura,
				searchComunicacionApertura, jqGridRequestDto, false);
	}

	/*
	 * MULTIFILTER
	 */

	/**
	 * Filter add.
	 * 
	 * filtro Filter Filter
	 * 
	 * @param filtro
	 *            the filtro the filter
	 * @return the filter
	 */
	@RequestMapping(value = "/multiFilter/add", method = RequestMethod.POST)
	public @ResponseBody() Filter filterAdd(
			@RequestJsonBody(param = "filtro") Filter filtro) {
		ComunicacionAperturaController.LOGGER
				.info("[POST - jqGrid] : add filter");

		return this.filterService.insert(filtro);
	}

	/**
	 * Filter delete.
	 * 
	 * filtro Filter Filter
	 * 
	 * @param filtro
	 *            the filtro the filter
	 * @return the filter
	 */
	@RequestMapping(value = "/multiFilter/delete", method = RequestMethod.POST)
	public @ResponseBody() Filter filterDelete(
			@RequestJsonBody(param = "filtro") Filter filtro) {
		ComunicacionAperturaController.LOGGER
				.info("[POST - jqGrid] : delete filter");
		return this.filterService.delete(filtro);
	}

	/**
	 * Filter get default.
	 * 
	 * filterSelector String filterUser String Filter
	 * 
	 * @param filterSelector
	 *            the filter selector
	 * @param filterUser
	 *            the filter user the filter
	 * @return the filter
	 */
	@RequestMapping(value = "/multiFilter/getDefault", method = RequestMethod.GET)
	public @ResponseBody() Filter filterGetDefault(
			@RequestParam(value = "filterSelector", required = true) String filterSelector,
			@RequestParam(value = "user", required = true) String filterUser) {
		ComunicacionAperturaController.LOGGER
				.info("[get - jqGrid] : getDefault filter");
		return this.filterService.getDefault(filterSelector, filterUser);
	}

	/**
	 * Filter get all.
	 * 
	 * filterSelector String filterUser String List<Filter>
	 * 
	 * @param filterSelector
	 *            the filter selector
	 * @param filterUser
	 *            the filter user the list
	 * @return the list
	 */
	@RequestMapping(value = "/multiFilter/getAll", method = RequestMethod.GET)
	public @ResponseBody() List<Filter> filterGetAll(
			@RequestParam(value = "filterSelector", required = true) String filterSelector,
			@RequestParam(value = "user", required = true) String filterUser) {
		ComunicacionAperturaController.LOGGER
				.info("[get - jqGrid] : GetAll filter");
		return this.filterService.getAllFilters(filterSelector, filterUser);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 * filterComunicacionApertura ComunicacionApertura Bean que contiene los
	 * parametros de filtrado a emplear. jqGridRequestDto Dto que contiene los
	 * parametros de configuracion propios del RUP_TABLE a aplicar en la
	 * busqueda. List<String> Lista de los identificadores de los registros
	 * eliminados.
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto the list
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<String> removeMultiple(
			@RequestJsonBody(param = "filter") ComunicacionApertura filterComunicacionApertura,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		ComunicacionAperturaController.LOGGER.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab04b56s00s");
		this.comunicAperturaService.removeMultiple(filterComunicacionApertura,
				jqGridRequestDto, false);
		ComunicacionAperturaController.LOGGER
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 * model Model
	 * 
	 * @param model
	 *            the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		// Ind. obra
		model.addAttribute("obra", Constantes.COMBO_SI_NO);

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

		// Indicador informe osalan
		model.addAttribute("indInformeOsalan", Constantes.COMBO_SI_NO);

		// Indicador informe inspeccion
		model.addAttribute("indInformeInspeccion", Constantes.COMBO_SI_NO);

		// Tareas Pendientes
		model.addAttribute("tareasPendientes",
				Constantes.COMBO_TAREAS_PENDIENTE);

		// Indicador de envio de notificacion
		model.addAttribute("indEnvio", Constantes.COMBO_TODAS_PENDIENTES);
	}

	/**
	 * Detalle expediente.
	 * 
	 * terape String anoape String numape Long expCreadoOK boolean borradoOK the
	 * borrado OK modo the modo tab Integer model Model request
	 * HttpServletRequest String
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param expCreadoOK
	 *            the exp creado OK
	 * @param borradoOK
	 *            the borrado OK
	 * @param modo
	 *            the modo
	 * @param tab
	 *            the tab
	 * @param model
	 *            the model
	 * @param request
	 *            the request the string
	 * @return the string
	 */
	@RequestMapping(value = "/detalle/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String detalleExpediente(@PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			@RequestParam(required = false, value = "expCreadoOK") Boolean expCreadoOK,
			@RequestParam(required = false, value = "borradoOK") Boolean borradoOK,
			@RequestParam(required = false, value = "modo") String modo,
			@RequestParam(required = false, value = "tab") Integer tab,
			Model model, HttpServletRequest request) {
		String modoAux = modo;
		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);

		boolean borrar = false;
		if ("E".equals(modoAux)) {
			modoAux = "C";
			borrar = true;
		}

		/**
		 * /** Accedemos al detalle pero con la información del filtro de
		 * expedientes
		 */
		DatosNavegacion datosNavegacion = ManejoSesion
				.getDatosNavegacion(request);
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();
		jQGridRequestDto.setSidx(datosNavegacion.getCampoOrden());
		jQGridRequestDto.setSord(datosNavegacion.getOrden());
		// Si existe un filtro de tipo Expedientes se pasa como parámetro
		ComunicacionApertura filtro = null;
		if (datosNavegacion.getFiltro() != null && ComunicacionApertura.class
				.equals(datosNavegacion.getFiltro().getClass())) {
			filtro = (ComunicacionApertura) datosNavegacion.getFiltro();
		}

		apertura = this.comunicAperturaService.findDetalle(apertura,
				jQGridRequestDto, filtro);

		// Pestaña seleccionada
		Integer tabAux = tab;
		if (tab == null) {
			tabAux = ComunicacionAperturaController.TAB_DETALLE_DEFECTO;
		}
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TAB_DEFECTO,
				tabAux.toString());

		if (Utilities.getInstance().isEmpty(apertura.getFolderId056())
				&& (expCreadoOK == null || Boolean.FALSE.equals(expCreadoOK))
				&& Constantes.VALUE_NO.equals(apertura.getMigrado056())) {
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_ALTA);
			request.getSession().setAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_ALTA);

			// Al entrar en un expediente en modo ALTA, guardamos cuál era el
			// modo anterior,
			// para recuperarlo si cambiamos de expediente a través de los
			// botones anterior/siguiente
			if (request.getSession().getAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR) == null) {
				this.guardarModoAnterior(modoAux, request);
			}
		} else if (Constantes.ESTADO_CERRADO.equals(apertura.getEstado056())
				|| Constantes.ESTADO_PROCESO_CIERRE
						.equals(apertura.getEstado056())
				|| Constantes.ESTADO_ELIMINADO
						.equals(apertura.getEstado056())) {
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_CONSULTA);
			request.getSession().setAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_CONSULTA);
		} else {

			if (!Utilities.getInstance().isEmpty(modoAux)) {
				if ("C".equals(modoAux)) {
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_CONSULTA);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_CONSULTA);

				} else if ("M".equals(modoAux)) {
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_MANTENIMIENTO);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_MANTENIMIENTO);
				} else if ("S".equals(modoAux)) {

					apertura.setDeseaRegistrar("");
					apertura.setNumReg(null);
					apertura.setFecReg(null);
					this.comunicAperturaService
							.modificarDatosRegistro(apertura);
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_SUBSANACION);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_SUBSANACION);
				} else if ("I".equals(modoAux)) {
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_INSPECCION);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_INSPECCION);
				} else if ("O".equals(modoAux)) {
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_OSALAN);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_OSALAN);
				} else if ("H".equals(modoAux)) {
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_HISTORICO);
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							Constantes.MODO_ACCESO_HISTORICO);
				}
				// Si viene por aquí es que viene de un expediente en modo ALTA
				// a través de los botones anterior/siguiente,
				// hay que recuperar cuál era el modo anterior a entrar en dicho
				// expediente en modo ALTA
				else if (Constantes.MODO_ACCESO_ALTA.equals(modoAux)) {

					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							request.getSession().getAttribute(
									ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR));
					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
							request.getSession().getAttribute(
									ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR));

					request.getSession().setAttribute(
							ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR,
							null);
				}
			}
		}

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Metemos la entidad Comunicación de apertura al modelo
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_BORRAR,
				borrar);

		if (expCreadoOK != null && Boolean.TRUE.equals(expCreadoOK)
				|| borradoOK != null && Boolean.TRUE.equals(borradoOK)) {
			model.addAttribute("feedback", Constantes.EXPEDIENTE_CREADO_OK);

			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_MANTENIMIENTO);
			request.getSession().setAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					Constantes.MODO_ACCESO_MANTENIMIENTO);
		}
		return "comunicacionAperturasForm";
	}

	/**
	 * Al entrar en un expediente en modo ALTA, guardamos cuál era el modo
	 * anterior, para recuperarlo si cambiamos de expediente a través de los
	 * botones anterior/siguiente
	 * 
	 * @param modoAux
	 *            String
	 * @param request
	 *            the request
	 */
	private void guardarModoAnterior(String modoAux,
			HttpServletRequest request) {

		if ("C".equals(modoAux)) {
			modoAux = Constantes.MODO_ACCESO_CONSULTA;
		} else if ("M".equals(modoAux)) {
			modoAux = Constantes.MODO_ACCESO_MANTENIMIENTO;
		} else if ("S".equals(modoAux)) {
			modoAux = Constantes.MODO_ACCESO_SUBSANACION;
		} else if ("H".equals(modoAux)) {
			modoAux = Constantes.MODO_ACCESO_HISTORICO;
		}

		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO_ANTERIOR,
				modoAux);
	}

	/**
	 * Detallecambiocoordinador.
	 * 
	 * terape String anoape String numape Long model Model request
	 * HttpServletRequest String
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param model
	 *            the model
	 * @param request
	 *            the request the string
	 * @return the string
	 */
	@RequestMapping(value = "/cambiocoordinador/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String detallecambiocoordinador(@PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			Model model, HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFind(apertura);

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Preparo la configuración de las opciones de tramitación
		String toolbarTramitacion = "";
		try {
			toolbarTramitacion = this.preparaToolbarCambioCoordinador();
		} catch (Exception e) {
			ComunicacionAperturaController.LOGGER
					.error("Error al generar el toolbar de estudio", e);
			toolbarTramitacion = "{buttons: []}";
		}
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_TRAMITACION,
				toolbarTramitacion);

		HttpSession session = request.getSession();
		if (session != null) {
			session.setAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);
		}

		return "cambiocoordinador";
	}

	/**
	 * Gets the tab notificacion.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab notificacion
	 * @return the tab notificacion
	 */
	@RequestMapping(value = "/tabNotificacion/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabNotificacion(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService
				.findComunicAperturaConNotificacion(apertura);

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)
				|| Constantes.MODO_ACCESO_SUBSANACION.equals(modoAcceso)) {
			ComunicacionApertura ape = this.comunicAperturaService
					.findDatosRegistro(apertura);
			apertura.setDeseaRegistrar(ape.getDeseaRegistrar());
			apertura.setNumReg(ape.getNumReg());
			apertura.setFecReg(ape.getFecReg());
		}

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

		HttpSession session = request.getSession();
		if (session != null) {
			session.setAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);
		}

		String toolbarNotificacion = this.preparaToolbarNotificacion(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_NOTIFICACION,
				toolbarNotificacion);
		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "tabNotificacion";
	}

	/**
	 * Modifica los datos de la pestaña de Datos del ERE del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. request
	 * HttpServletRequest Denuncia Bean resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/tabNotificacion/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabNotificacion(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request) {

		HttpSession session = request.getSession();

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			this.machacarIdsDatosApertura(comunicacionApertura,
					comunicAperturaSess);
		}
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		// Validate
		List<ErrorField> errores = new ArrayList<ErrorField>();

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)) {

			comunicacionApertura.setHistorico(false);

			if (Constantes.VALUE_NO
					.equals(comunicacionApertura.getDeseaRegistrar())) {
				if (Utilities.getInstance()
						.isEmpty(comunicacionApertura.getNumReg())) {
					errores.add(new ErrorField("aperturas.detalle.numReg",
							"validacion.obligatorio"));
				}
				if (comunicacionApertura.getFecReg() == null) {
					errores.add(new ErrorField("aperturas.detalle.fecReg",
							"validacion.obligatorio"));
				}
			}

			DatosNotificacion datosNotificacion = comunicacionApertura
					.getDatosNotificacion();

			// Si es notif. postal y se ha introducido localidad y CP, se valida
			if (datosNotificacion.getCanalnotif066() != null
					&& Constantes.CANAL_NOTIF_POSTAL
							.equals(datosNotificacion.getCanalnotif066())
					&& datosNotificacion.getDatosLocalizacion() != null
					&& datosNotificacion.getDatosLocalizacion()
							.getLocalidad() != null
					&& datosNotificacion.getDatosLocalizacion().getLocalidad()
							.getCodLocalidad() != null
					&& datosNotificacion.getDatosLocalizacion()
							.getCodpostal067() != null) {

				errores = this.comunicacionAperturaValidator
						.validateLocalidadCP(comunicacionApertura);

			}

		} else {
			errores = this.comunicacionAperturaValidator
					.validate(comunicacionApertura, Oper.EDIT_TAB_NOTIFICACION);
			comunicacionApertura.setHistorico(true);
			if (Constantes.MODO_ACCESO_SUBSANACION.equals(modoAcceso)) {

				if (Constantes.VALUE_NO
						.equals(comunicacionApertura.getDeseaRegistrar())) {
					if (Utilities.getInstance()
							.isEmpty(comunicacionApertura.getNumReg())) {
						errores.add(new ErrorField("aperturas.detalle.numReg",
								"validacion.obligatorio"));
					}
					if (comunicacionApertura.getFecReg() == null) {
						errores.add(new ErrorField("aperturas.detalle.fecReg",
								"validacion.obligatorio"));
					}
				}
			}
		}

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		this.comunicAperturaService
				.modificarDatosTabNotificacion(comunicacionApertura, false);

		if (comunicacionApertura.getFolderId056() != null) {

			DatosNotificacion datosNotificacionYAviso = this.datosNotificacionService
					.findConLocalizacionYAvisos(
							comunicacionApertura.getDatosNotificacion());

			try {
				reeService.modificarDatosNotificacionExpedienteREE(

						comunicacionApertura.getFolderId056(),
						datosNotificacionYAviso);
			} catch (Exception e) {
				errores.add(new ErrorField("Datos Notificacion",
						"No se han guardado en el Repositorio de Expedientes"));
				throw new ErrorGenericoException(errores);
			}
		}

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)
				|| Constantes.MODO_ACCESO_SUBSANACION.equals(modoAcceso)) {
			this.comunicAperturaService
					.modificarDatosRegistro(comunicacionApertura);
		}

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");
		return comunicacionApertura;
	}

	/**
	 * Gets the lista datos aviso.
	 * 
	 * jqGridRequestDto JQGridRequestDto model Model request HttpServletRequest
	 * String
	 * 
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request the lista datos aviso
	 * @return the lista datos aviso
	 */
	@RequestMapping(value = "/tabNotificacion/datosAviso/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<DatosAviso> getListaDatosAviso(
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request) {

		HttpSession session = request.getSession();
		DatosAviso filterDatosAviso = new DatosAviso();

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			filterDatosAviso.setDatosNotificacion(
					comunicAperturaSess.getDatosNotificacion());
		}

		if (filterDatosAviso.getDatosNotificacion()
				.getCodDatosNotif066() == null) {
			filterDatosAviso.getDatosNotificacion().setCodDatosNotif066(0);
		}

		return this.datosAvisoService.filter(filterDatosAviso, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * datosAviso DatosAviso Bean que contiene la informacion con la que se va a
	 * crear el nuevo registro. request HttpServletRequest SolPersonas Bean
	 * resultante del proceso de creacion.
	 * 
	 * @param datosAviso
	 *            the datos aviso
	 * @param request
	 *            the request the datos aviso
	 * @return the datos aviso
	 */
	@RequestMapping(value = "tabNotificacion/datosAviso", method = RequestMethod.POST)
	public @ResponseBody() DatosAviso addDatosAviso(
			@RequestBody() DatosAviso datosAviso, HttpServletRequest request) {

		HttpSession session = request.getSession();
		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

			if (comunicAperturaSess.getDatosNotificacion() != null
					&& comunicAperturaSess.getDatosNotificacion() != null) {
				datosAviso.setDatosNotificacion(
						comunicAperturaSess.getDatosNotificacion());

			}
		}

		DatosAviso datosAvisoAux = this.datosAvisoService.add(datosAviso);
		ComunicacionAperturaController.LOGGER
				.info("[POST] : DatosAviso insertado correctamente");
		return datosAvisoAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * idDatoAviso068 Integer Identificador del objeto que se desea eliminar.
	 * 
	 * request HttpServletRequest SolPersonas Bean eliminado.
	 * 
	 * @param idDatoAviso068
	 *            the id dato aviso 068
	 * @param request
	 *            the request the datos aviso
	 * @return the datos aviso
	 */
	@RequestMapping(value = "/tabNotificacion/datosAviso/{idDatoAviso068}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() DatosAviso removeSolicitud(
			@PathVariable() Long idDatoAviso068, HttpServletRequest request) {

		DatosAviso datosAvisoBorrar = new DatosAviso(idDatoAviso068);
		this.datosAvisoService.remove(datosAvisoBorrar);

		return datosAvisoBorrar;
	}

	/**
	 * Gets the tab produccion almac.
	 * 
	 * model Model terape String anoape String numape Long request the request
	 * String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab produccion almac
	 * @return the tab produccion almac
	 */
	@RequestMapping(value = "/tabProduccionAlmac/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabProduccionAlmac(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape, HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFindDetalle(apertura);

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		String toolbarProcAlmac = this.preparaToolbarProdAlmac(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_PROC_ALMAC,
				toolbarProcAlmac);

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "tabProduccionAlmac";
	}

	/**
	 * Gets the tab proyectistas.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab proyectistas
	 * @return the tab proyectistas
	 */
	@RequestMapping(value = "/tabProyectistas/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabProyectistas(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		/*
		 * ComunicacionApertura apertura = new ComunicacionApertura(terape,
		 * anoape, numape); apertura =
		 * this.comunicAperturaService.vFindDetalle(apertura);
		 * 
		 * // Metemos la entidad Comunicación de apertura al modelo
		 * model.addAttribute(
		 * ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
		 * apertura); HttpSession session = request.getSession(); if (session !=
		 * null) { session.setAttribute(
		 * ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
		 * apertura); }
		 */
		return "tabProyectistas";
	}

	/**
	 * Gets the tab datos obra.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab datos obra
	 * @return the tab datos obra
	 */
	@RequestMapping(value = "/tabDatosObra/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabDatosObra(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.findConObra(apertura);

		if (apertura.getRegemp056() != null) {
			String[] regemp = apertura.getRegemp056().split("/");
			apertura.setRegemp1(regemp[0]);
			apertura.setRegemp2(regemp[1]);
			apertura.setRegemp3(regemp[ConstantesNum.NUM_2]);
		}

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);
		HttpSession session = request.getSession();
		if (session != null) {
			session.setAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);
		}

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		String toolbarDatosObra = this.preparaToolbarDatosObra(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_OBRA,
				toolbarDatosObra);

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "tabDatosObra";
	}

	/**
	 * Gets the tab coordinadores.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab coordinadores
	 * @return the tab coordinadores
	 */
	@RequestMapping(value = "/tabCoordinadores/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabCoordinadores(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape, HttpServletRequest request) {

		/*
		 * ComunicacionApertura apertura = new ComunicacionApertura(terape,
		 * anoape, numape); apertura =
		 * this.comunicAperturaService.vFind(apertura);
		 * 
		 * // Metemos la entidad Comunicación de apertura al modelo
		 * model.addAttribute(
		 * ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
		 * apertura); HttpSession session = request.getSession(); if (session !=
		 * null) { session.setAttribute(
		 * ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
		 * apertura); }
		 */
		return "tabCoordinadores";
	}

	/**
	 * Gets the tab datos empresa.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab datos empresa
	 * @return the tab datos empresa
	 */
	@RequestMapping(value = "/tabDatosEmpresa/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabDatosEmpresa(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFindDetalle(apertura);

		apertura.setDatosNotificacion(this.datosNotificacionService
				.findConLocalizacionYAvisos(apertura.getDatosNotificacion()));

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		String toolbarDatosEmpresa = this.preparaToolbarDatosEmpresa(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_EMPRESA,
				toolbarDatosEmpresa);

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "tabDatosEmpresa";
	}

	/**
	 * Modifica los datos de la pestaña de Empresa del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. request
	 * HttpServletRequest Denuncia Bean resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/tabDatosEmpresa/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabDatosEmpresa(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request) {

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator
				.validate(comunicacionApertura, Oper.EDIT_TAB_DATOS_EMPRESA);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)) {
			comunicacionApertura.setHistorico(false);
		} else {
			comunicacionApertura.setHistorico(true);
		}

		if (Constantes.CANAL_NOTIF_POSTAL.equals(comunicacionApertura
				.getDatosNotificacion().getCanalnotif066())) {
			this.comunicAperturaService
					.modificarDatosTabNotificacion(comunicacionApertura, false);
		}

		this.comunicAperturaService
				.modificarDatosTabDatosEmpresa(comunicacionApertura);
		this.comunicAperturaService
				.modificarDatosTabDatosCentro(comunicacionApertura);

		this.comunicAperturaService.modificarIndObra(comunicacionApertura);

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");
		return comunicacionApertura;
	}

	/**
	 * Gets the tab datos centro.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab datos centro
	 * @return the tab datos centro
	 */
	@RequestMapping(value = "/tabDatosCentro/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabDatosCentro(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFindDetalle(apertura);

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Metemos en sesión el valor del estado de la visita, para controlar si
		// se modifica
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_ESTADO_VISITA_OSALAN,
				apertura.getVisosl056());

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		String toolbarDatosCentro = this.preparaToolbarDatosCentro(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DATOS_CENTRO,
				toolbarDatosCentro);

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "tabDatosCentro";
	}

	/**
	 * Modifica los datos de la pestaña de Datos del ERE del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. request
	 * HttpServletRequest Denuncia Bean resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 * @throws AB04BException
	 *             the exception
	 */
	@RequestMapping(value = "/tabDatosCentro/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabDatosCentro(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request) throws AB04BException {

		ComunicacionApertura comunicacionAperturaAux = comunicacionApertura;

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator
				.validate(comunicacionAperturaAux, Oper.EDIT_TAB_DATOS_CENTRO);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)) {
			comunicacionAperturaAux.setHistorico(false);
		} else {
			comunicacionAperturaAux.setHistorico(true);
		}

		this.comunicAperturaService
				.modificarDatosTabDatosCentro(comunicacionAperturaAux);

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");

		comunicacionAperturaAux = this.comunicAperturaService
				.vFindDetalle(comunicacionAperturaAux);

		String estadoVisitaAnt = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_ESTADO_VISITA_OSALAN);

		if (comunicacionAperturaAux.getVisosl056() != null
				&& comunicacionAperturaAux.getVisosl056()
						.equals(Constantes.ESTADO_VISITA_VISITADA)
				&& !comunicacionAperturaAux.getVisosl056()
						.equals(estadoVisitaAnt)) {

			// cargamos lista tareas del expediente
			TareaAperturas filterTarea = new TareaAperturas();
			TramiteAperturas filterTramite = new TramiteAperturas();
			filterTramite.setApertura(comunicacionAperturaAux);
			filterTarea.setTramiteAperturas(filterTramite);
			List<TareaAperturas> listaTareas = this.tareaAperturaService
					.findAllTareatramite(filterTarea, null);

			boolean crearVisita = true;
			// comprobamos que no hay tareas de un trámite de visita
			// anterior
			// pendientes de ejecutar
			for (TareaAperturas tarea : listaTareas) {
				if ((TipoTareaFlujo.ADJUNTAR_INFORME
						.esEquivalente(tarea.getTipoTarea().getTaskId090())
						|| TipoTareaFlujo.REGISTRA_INFORME_SALIDA.esEquivalente(
								tarea.getTipoTarea().getTaskId090())
						|| TipoTareaFlujo.REGISTRA_INFORME_ENTRADA
								.esEquivalente(
										tarea.getTipoTarea().getTaskId090()))
						&& !EstadosTareas.EJECUTADA.getEstado()
								.equals(tarea.getEstado063())) {

					crearVisita = false;
					break;
				}
			}

			if (crearVisita) {
				this.plateaTramitacionService.crearTarea(
						Utilities.getInstance().obtenerProcedureIdApertura(),
						TipoTramiteFlujo.APORTAR_INFORME_VISITA.name(),
						TipoTareaFlujo.ADJUNTAR_INFORME.getTaskId(),
						comunicacionAperturaAux.getFolderId056(),
						UtilSeguridad.getInstance().getUserCredentials()
								.getPosition(),
						UtilSeguridad.getInstance().getNombre());
			}

			/*
			 * // Buscamos si ya existe un trámite de APORTAR_INFORME_VISITA
			 * para // el expediente Tramite tramite = this.tramiteService
			 * .findByProceedingIdProcedureId(
			 * TipoTramiteFlujo.APORTAR_INFORME_VISITA.name(),
			 * Utilities.getInstance() .obtenerProcedureIdApertura());
			 * 
			 * TramiteAperturas tramiteApertura = this.tramiteAperturaService
			 * .findLastTramiteByTipo(tramite.getIdTramite089(),
			 * comunicacionApertura); // si no existe, lo creamos if
			 * (tramiteApertura == null) {
			 * this.plateaTramitacionService.crearTarea(Utilities
			 * .getInstance().obtenerProcedureIdApertura(),
			 * TipoTramiteFlujo.APORTAR_INFORME_VISITA.name(),
			 * TipoTareaFlujo.ADJUNTAR_INFORME.getTaskId(),
			 * comunicacionApertura.getFolderId056(), UtilSeguridad
			 * .getInstance().getNif(), UtilSeguridad
			 * .getInstance().getNombre()); }
			 */
		}

		// Metemos en sesión el valor del estado de la visita, para
		// controlar si
		// se modifica
		request.getSession().setAttribute(
				ComunicacionAperturaController.ATTR_NAME_ESTADO_VISITA_OSALAN,
				comunicacionAperturaAux.getVisosl056());

		return comunicacionAperturaAux;

	}

	/**
	 * Buscar empresa.
	 * 
	 * tipoIdentif String numeroDocumento String Ramas
	 * 
	 * @param tipoIdentif
	 *            the tipo identif
	 * @param numeroDocumento
	 *            the numero documento the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "buscarEmpresa", method = RequestMethod.GET)
	public @ResponseBody() ComunicacionApertura buscarEmpresa(
			@RequestParam(value = "tipoIdentif") String tipoIdentif,
			@RequestParam(value = "numeroDocumento") String numeroDocumento) {
		ComunicacionApertura aperturaFind = new ComunicacionApertura();
		aperturaFind.setTipdoc056(tipoIdentif);
		aperturaFind.setNumdoc056(numeroDocumento);
		aperturaFind.setIndobra056(Constantes.VALUE_SI);

		List<ComunicacionApertura> listaComunicacionesAperturas = this.comunicAperturaService
				.findEmpresaObra(aperturaFind);

		if (listaComunicacionesAperturas != null
				&& listaComunicacionesAperturas.size() > 0) {
			return listaComunicacionesAperturas.get(0);
		} else {

			throw new ErrorGenericoException("");
		}
	}

	/**
	 * Modifica los datos de la pestaña de Datos del ERE del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. request
	 * HttpServletRequest Denuncia Bean resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/tabProduccionAlmac/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabProduccionAlmac(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request) {

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator
				.validate(comunicacionApertura, Oper.EDIT_TAB_PROC_ALMAC);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)) {
			comunicacionApertura.setHistorico(false);
		} else {
			comunicacionApertura.setHistorico(true);
		}
		this.comunicAperturaService
				.modificarDatosTabProcAlmac(comunicacionApertura);

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");
		return comunicacionApertura;
	}

	/**
	 * Modifica los datos de la pestaña de Datos del ERE del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. request
	 * HttpServletRequest Denuncia Bean resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/tabDatosObra/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabDatosObra(
			@RequestBody() ComunicacionApertura comunicacionApertura,
			HttpServletRequest request) {

		// Validate
		List<ErrorField> errores = this.comunicacionAperturaValidator
				.validate(comunicacionApertura, Oper.EDIT_TAB_DATOS_OBRA);
		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)) {
			comunicacionApertura.setHistorico(false);
		} else {
			comunicacionApertura.setHistorico(true);
		}
		this.comunicAperturaService
				.modificarDatosTabDatosObra(comunicacionApertura);

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");
		return comunicacionApertura;
	}

	/**
	 * Gets the tab documentos.
	 * 
	 * model Model request HttpServletRequest terape String anoape String numape
	 * Long String
	 * 
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the tab documentos
	 * @return the tab documentos
	 */
	@RequestMapping(value = "/tabDocumentos/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabDocumentos(Model model, HttpServletRequest request,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) {

		ComunicacionAperturaController.LOGGER.info("Entra en getTabDocumentos");

		String iframe = (String) request.getParameter("iframe");

		String modoAcceso = "";

		if (iframe == null) {
			modoAcceso = (String) request.getSession().getAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		} else {
			modoAcceso = Constantes.MODO_ACCESO_CONSULTA;
		}

		// cargamos apertura
		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);

		apertura = comunicAperturaService.vFindDetalle(apertura);

		// String modoAcceso = Constantes.MODO_ACCESO_MANTENIMIENTO;
		// Cargamos la lista de trámites

		List<TramiteAperturas> listaTramites = new ArrayList<TramiteAperturas>();
		List<DocumentoAperturas> listaDocs = new ArrayList<DocumentoAperturas>();
		TipoDocumento tipoDoc = null;
		try {
			if (Constantes.MODO_ACCESO_ALTA.equals(modoAcceso)
					|| Constantes.MODO_ACCESO_MANTENIMIENTO.equals(modoAcceso)
					|| Constantes.MODO_ACCESO_SUBSANACION.equals(modoAcceso)) {
				DocumentoAperturas filterDoc = new DocumentoAperturas();
				filterDoc.setIdapetemp065(apertura.getIdape056());
				tipoDoc = new TipoDocumento();
				tipoDoc.setAportGen091(Constantes.TIPO_DOCUMENTO_APORTADO);
				filterDoc.setTipoDocumento(tipoDoc);
				listaDocs = this.documentoAperturaService
						.findAllAperturaTipoTemp(filterDoc);

				TramiteAperturas tramite = new TramiteAperturas();
				tramite.setListaDocumentos(listaDocs);
				listaTramites.add(tramite);

			} else if (Constantes.MODO_ACCESO_INSPECCION.equals(modoAcceso)) {
				DocumentoAperturas filterDoc = new DocumentoAperturas();
				filterDoc.setIdapetemp065(apertura.getIdape056());
				tipoDoc = new TipoDocumento();
				tipoDoc.setAportGen091(Constantes.TIPO_DOCUMENTO_APORTADO);
				filterDoc.setTipoDocumento(tipoDoc);
				listaDocs = this.documentoAperturaService
						.findAllAperturaInspeccion(filterDoc);

				TramiteAperturas tramite = new TramiteAperturas();
				tramite.setListaDocumentos(listaDocs);
				listaTramites.add(tramite);

			} else if (Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
				if (apertura.getMigrado056().equals("N")) {
					TramiteAperturas filterTramite = new TramiteAperturas();
					filterTramite.setApertura(apertura);

					JQGridRequestDto jqGridTramites = new JQGridRequestDto();
					jqGridTramites.setSidx("ID_TRAMITE_062");
					jqGridTramites.setSord("ASC");
					listaTramites = this.tramiteAperturaService
							.findAll(filterTramite, jqGridTramites);
					// Cargamos los documentos de cada trámite
					for (TramiteAperturas tramite : listaTramites) {
						DocumentoAperturas filterDoc = new DocumentoAperturas();
						filterDoc.setTramiteAperturas(tramite);
						tipoDoc = new TipoDocumento();
						filterDoc.setTipoDocumento(tipoDoc);
						listaDocs = this.documentoAperturaService
								.findAll(filterDoc, null);

						tramite.setListaDocumentos(listaDocs);
					}
				} else {

					FolderDocumentList fdl = comunicAperturaService
							.obtenerDocumentosMigrados(
									apertura.getFolderId056());

					Iterator<FolderDoc> igenerado = fdl
							.getGeneratedDocumentList().getFolderDoc()
							.iterator();
					Iterator<FolderDoc> iaportado = fdl
							.getContributedDocumentList().getFolderDoc()
							.iterator();

					TramiteAperturas tramiteapertura = new TramiteAperturas();
					Tramite tramite = new Tramite();
					tramite.setDescripcionEs089("Documentos Generados");
					tramite.setDescripcionEu089("Sortutako Dokumentuak");
					tramiteapertura.setTipoTramite(tramite);

					SimpleDateFormat sdf = new SimpleDateFormat(
							"dd-MM-yyyy HH:mm:ss");

					while (igenerado.hasNext()) {
						FolderDoc fdgenerado = igenerado.next();

						Iterator<DocumentStorageInfo> dsiterator = fdgenerado
								.getDocumentStorageList()
								.getDocumentStorageInfo().iterator();

						while (dsiterator.hasNext()) {

							DocumentStorageInfo dsi = dsiterator.next();

							DocumentoAperturas dagenerado = new DocumentoAperturas();
							dagenerado.setNombreDoc065(dsi.getSourceName());

							dagenerado.setFechaDoc065(sdf
									.parse(fdgenerado.getRegistryTimeStamp()));
							dagenerado.setOidDokusi065(dsi.getDocOID());

							String formato = "E";
							if (!dsi.getFormat().equals("")) {
								formato = dsi.getFormat();
							}

							dagenerado.setFormatoAport065(formato);
							dagenerado.setOrigen065(1);

							TipoDocumento tipo = new TipoDocumento();

							ElementNSImpl object = (ElementNSImpl) dsi
									.getRoleName();

							String des_eu = object.getFirstChild()
									.getFirstChild().getFirstChild()
									.getNodeValue();
							String des_es = object.getFirstChild()
									.getFirstChild().getNextSibling()
									.getFirstChild().getNodeValue();

							tipo.setDescripcionEu091(des_eu);
							tipo.setDescripcionEs091(des_es);

							dagenerado.setTipoDocumento(tipo);
							dagenerado.setMigrado(true);

							listaDocs.add(dagenerado);
						}

					}

					tramiteapertura.setListaDocumentos(listaDocs);
					listaTramites.add(tramiteapertura);

					listaDocs = new ArrayList<DocumentoAperturas>();

					TramiteAperturas tramiteapertura2 = new TramiteAperturas();
					Tramite tramite2 = new Tramite();
					tramite2.setDescripcionEs089("Documentos Aportados");
					tramite2.setDescripcionEu089("Aurkeztutako Dokumentuak");
					tramiteapertura2.setTipoTramite(tramite2);

					while (iaportado.hasNext()) {
						FolderDoc fdaporado = iaportado.next();

						Iterator<DocumentStorageInfo> dsiterator2 = fdaporado
								.getDocumentStorageList()
								.getDocumentStorageInfo().iterator();

						while (dsiterator2.hasNext()) {

							DocumentStorageInfo dsi2 = dsiterator2.next();
							DocumentoAperturas daporado = new DocumentoAperturas();
							daporado.setNombreDoc065(dsi2.getSourceName());

							daporado.setFechaDoc065(sdf.parse(fdaporado
									.getRegistrySubmissionTimeStamp()));
							daporado.setOidDokusi065(dsi2.getDocOID());

							String formato = "E";
							if (!dsi2.getFormat().equals("")) {
								formato = dsi2.getFormat();
							}

							daporado.setFormatoAport065(formato);
							daporado.setOrigen065(0);

							TipoDocumento tipo = new TipoDocumento();

							ElementNSImpl object = (ElementNSImpl) dsi2
									.getRoleName();

							String des_eu = object.getFirstChild()
									.getFirstChild().getFirstChild()
									.getNodeValue();
							String des_es = object.getFirstChild()
									.getFirstChild().getNextSibling()
									.getFirstChild().getNodeValue();

							tipo.setDescripcionEu091(des_eu);
							tipo.setDescripcionEs091(des_es);

							daporado.setTipoDocumento(tipo);
							daporado.setMigrado(true);

							listaDocs.add(daporado);
						}
					}

					tramiteapertura2.setListaDocumentos(listaDocs);
					listaTramites.add(tramiteapertura2);

				}
			}
			apertura.setListaTramites(listaTramites);
		} catch (Exception e) {
			LOGGER.error("ERROR tabDocumentos " + e.getMessage());
		}
		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);
		if (iframe == null) {
			request.getSession().setAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
					modoAcceso);
		}

		model.addAttribute("iframe", iframe);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Cargamos la URL de descarga del applet de digitalizacion
		model.addAttribute("urlappletdigitalizacion",
				PropertiesUtil.getProperty(PropertiesUtil.URL_DESCARGA_APPLET));

		// territorio para serie documental
		request.getSession().setAttribute("terape", apertura.getTerape056());
		// tipo de documento para la digitalización
		request.getSession().setAttribute("docType", Constantes.APE);

		// Preparo la configuración de las opciones de tramitación
		String toolbarDocumentos = this.preparaToolbarDocumentos(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_DOCUMENTOS_REG,
				toolbarDocumentos);

		return "tabDocumentos";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * deseaReg String numReg String fecReg Date request HttpServletRequest
	 * model Model String
	 * 
	 * @param deseaReg
	 *            the desea reg
	 * @param numReg
	 *            the num reg
	 * @param fecReg
	 *            the fec reg
	 * @param request
	 *            the request
	 * @param model
	 *            the model the string
	 * @return the string
	 */
	@RequestMapping(value = "/tabDocumentos/modificar", method = RequestMethod.GET)
	public @ResponseBody() String modificarTabDocumentos(
			@RequestParam(value = "deseaReg", required = false) String deseaReg,
			@RequestParam(value = "numReg", required = false) String numReg,
			@RequestParam(value = "fecReg", required = false) Date fecReg,
			HttpServletRequest request, Model model) {

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();
		String modoAcceso = "";
		HttpSession session = request.getSession();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);
			modoAcceso = (String) request.getSession().getAttribute(
					ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);

		}

		ComunicacionApertura apertura = this.comunicAperturaService
				.findDetalle(comunicAperturaSess, null, null);

		// Obtenemos la lista de los documentos antiguos
		TramiteAperturas filterTramite = new TramiteAperturas();
		filterTramite.setApertura(apertura);
		JQGridRequestDto jqGridTramites = new JQGridRequestDto();
		jqGridTramites.setSidx("ID_TRAMITE_062");
		jqGridTramites.setSord("ASC");
		List<TramiteAperturas> listaTramites = this.tramiteAperturaService
				.findAll(filterTramite, jqGridTramites);
		TipoDocumento tipoDoc;
		List<DocumentoAperturas> listaDocs = new ArrayList<DocumentoAperturas>();
		// Cargamos los documentos de cada trámite
		for (TramiteAperturas tramite : listaTramites) {
			DocumentoAperturas filterDoc = new DocumentoAperturas();
			filterDoc.setTramiteAperturas(tramite);
			tipoDoc = new TipoDocumento();
			filterDoc.setTipoDocumento(tipoDoc);
			listaDocs.addAll(
					this.documentoAperturaService.findAll(filterDoc, null));
		}

		List<ErrorField> errores = new ArrayList<ErrorField>();
		if (Constantes.MODO_ACCESO_MANTENIMIENTO.equals(modoAcceso)
				&& Constantes.VALUE_NO.equals(deseaReg)) {
			if (Utilities.getInstance().isEmpty(numReg)) {
				errores.add(new ErrorField("aperturas.detalle.numReg",
						"validacion.obligatorio"));
			}
			if (fecReg == null) {
				errores.add(new ErrorField("aperturas.detalle.fecReg",
						"validacion.obligatorio"));
			}
		}

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		apertura.setDeseaRegistrar(deseaReg);
		apertura.setNumReg(numReg);
		apertura.setFecReg(fecReg);

		// recoger de la tabla temporal
		DocumentoAperturas docFilter = new DocumentoAperturas();
		docFilter.setIdapetemp065(apertura.getIdape056());

		try {
			List<DocumentoAperturas> listaDocumentos = this.copiarDocsR02G(
					apertura.getIdape056(), apertura.getTerape056(), false);
			// this.documentoAperturaService
			// .buscarDocumentosAperturasTempIdApe(docFilter);
			guardarDocsHistorial(listaDocs, listaDocumentos, apertura);
			// listaDocumentos.add(this.documentoAperturasService
			// .find(new DocumentoAperturas(146L)));
			ContextSubmission contextSubmission = this.ppsAportacionService
					.crearContextSubmission(false, apertura, listaDocumentos);

			this.ppsAportacionService
					.enviarAportacionPresencial(contextSubmission);
			// PPSReturnInfo ppsReturnInfo = PPSUtils.getInstance()
			// .obtenerPPSReturnInfo(requestReturn);

		} catch (Exception e) {
			this.documentoAperturaService.removeTempByIdApertura(docFilter);
			errores.add(
					new ErrorField("comunicacion.apertura", "error.apertura"));
			throw new ErrorGenericoException(errores);
		}

		model.addAttribute(ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO,
				modoAcceso);

		return "ok";

	}

	/**
	 * guardarDocsHistorial.
	 * 
	 * 
	 * @param listaDocsAnt
	 *            the desea reg
	 * @param listaDocsNuevos
	 *            the num reg
	 * @param apertura
	 *            the fec reg
	 */
	private void guardarDocsHistorial(List<DocumentoAperturas> listaDocsAnt,
			List<DocumentoAperturas> listaDocsNuevos,
			ComunicacionApertura apertura) {
		String cadenaDocsAnt = HistCambiosAperturasUtil
				.concatenarCamposDocumentos(
						(ArrayList<DocumentoAperturas>) listaDocsAnt);
		String cadenaDocsNuevo = HistCambiosAperturasUtil
				.concatenarCamposDocumentos(
						(ArrayList<DocumentoAperturas>) listaDocsNuevos);
		cadenaDocsAnt.charAt(1);
		cadenaDocsNuevo.charAt(1);

		if (!listaDocsNuevos.isEmpty()
				&& !cadenaDocsAnt.equals(cadenaDocsNuevo)) {
			// registrar historico cambios
			HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
			histCambioAperturas.setIdape087(apertura.getIdape056());
			if (apertura.getMigrado056() != null
					&& Constantes.VALUE_SI.equals(apertura.getMigrado056())) {
				histCambioAperturas
						.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
			} else {
				histCambioAperturas
						.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
			}

			histCambioAperturas.setRegoriginal087(cadenaDocsAnt);
			histCambioAperturas.setRegmidificaciones087(cadenaDocsNuevo);
			histCambioAperturas.setFecmodif087(new Date());
			histCambioAperturas.setTipocambio087(
					TipoCambio.MODIFICACION_APERTURA.getCodigo());

			this.histCambiosAperturasService.add(histCambioAperturas);
		}

	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * deseaReg String numReg String fecReg Date request HttpServletRequest
	 * model Model String
	 * 
	 * @param deseaReg
	 *            the desea reg
	 * @param numReg
	 *            the num reg
	 * @param fecReg
	 *            the fec reg
	 * @param request
	 *            the request
	 * @param model
	 *            the model the string
	 * @return the string
	 */
	@RequestMapping(value = "/tabDocumentos/guardarInforme", method = RequestMethod.GET)
	public @ResponseBody() String guardarInforme(HttpServletRequest request,
			Model model) {

		ComunicacionApertura comunicAperturaSess = new ComunicacionApertura();

		HttpSession session = request.getSession();
		if (session != null) {
			comunicAperturaSess = (ComunicacionApertura) session.getAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE);

		}

		ComunicacionApertura apertura = this.comunicAperturaService
				.findDetalle(comunicAperturaSess, null, null);

		try {

			apertura.setUsuarioTram(UtilSeguridad.getInstance()
					.getUserCredentials().getPosition());
			this.comunicAperturaService.updateUsuariosTramitacion(apertura);

			this.plateaTramitacionService.crearTarea(
					Utilities.getInstance().obtenerProcedureIdApertura(),
					TipoTramiteFlujo.ADJUNTAR_INFORME_INSPECCION.name(),
					TipoTareaFlujo.ADJUNTAR_INFORME_INSPECCION.getTaskId(),
					apertura.getFolderId056(),
					UtilSeguridad.getInstance().getUserCredentials()
							.getPosition(),
					UtilSeguridad.getInstance().getNombre());

			// Metemos la entidad Comunicación de apertura al modelo
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);

		} catch (Exception e) {
			DocumentoAperturas docFilter = new DocumentoAperturas();
			docFilter.setIdapetemp065(apertura.getIdape056());

			// borrar los temporales
			this.documentosAperturasTempDao.removeByIdApertura(docFilter);
			return "ko";
		}

		return "ok";

	}

	/**
	 * Gets the tab tramitacion.
	 * 
	 * model Model terape String anoape String numape Long String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the tab tramitacion
	 * @return the tab tramitacion
	 */
	@RequestMapping(value = "/tabTramitacion/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabTramitacion(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape) {

		ComunicacionAperturaController.LOGGER
				.info("Entra en getTabTramitacion");

		// cargamos apertura
		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.find(apertura);

		// cargamos lista tareas
		TareaAperturas filterTarea = new TareaAperturas();
		TramiteAperturas filterTramite = new TramiteAperturas();
		filterTramite.setApertura(apertura);
		filterTarea.setTramiteAperturas(filterTramite);
		List<TareaAperturas> listaTareas = this.tareaAperturaService
				.findAllTareatramite(filterTarea, null);
		revisarErrorTarea(listaTareas);
		apertura.setListaTareas(listaTareas);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// comprobamos si no hay tareas pendientes, para mostrar el botón cerrar
		// expediente.
		boolean cerrarExp = true;
		boolean crearEstudio = true;
		boolean abrirExpediente = false;
		for (TareaAperturas tarea : listaTareas) {
			if (!EstadosTareas.EJECUTADA.getEstado()
					.equals(tarea.getEstado063())) {
				cerrarExp = false;

				if (TipoTareaFlujo.ESTUDIO
						.esEquivalente(tarea.getTipoTarea().getTaskId090())) {
					crearEstudio = false;
				}

			} else if (TipoTareaFlujo.CIERRE
					.esEquivalente(tarea.getTipoTarea().getTaskId090())) {
				cerrarExp = false;
			}
		}

		// comprobamos si el expediente está en estado='S' (no se ha abierto
		// correctamente),
		// para poner el botón 'Abrir Expediente'
		if (apertura.getEstado056() != null
				&& apertura.getEstado056().equals("S")) {
			cerrarExp = false;
			crearEstudio = false;
			// comprobar si han pasado por lo menos 5 minutos desde que se ha
			// puesto en estado='S'
			Date now = new Date();
			Long diff = 0L;
			if (apertura.getFecpre056() != null) {
				diff = now.getTime() - apertura.getFecpre056().getTime();
			}
			if (diff > ComunicacionAperturaController.MIN_WAIT_REOPEN) {
				abrirExpediente = true;
			} else {
				abrirExpediente = false;
			}
		}

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_CERRAR_EXPEDIENTE,
				cerrarExp);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_CREAR_ESTUDIO,
				crearEstudio);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_ABRIR_EXPEDIENTE,
				abrirExpediente);

		// Preparo la configuración de las opciones de tramitación
		String toolbarTramitacion = "";
		try {
			// TODO obtener el modo acceso en función del usuario
			toolbarTramitacion = this.preparaToolbarTramitacion(apertura,
					Constantes.MODO_ACCESO_MANTENIMIENTO);
		} catch (Exception e) {
			ComunicacionAperturaController.LOGGER
					.error("Error al generar el toolbar de tramitacion", e);
			toolbarTramitacion = "{buttons: []}";
		}
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_TRAMITACION,
				toolbarTramitacion);

		return "tabTramitacion";
	}

	private void revisarErrorTarea(List<TareaAperturas> listaTareas) {
		String error = "";
		String tipoTarea = "";
		TareaAperturas tarea = null;
		TareaAperturas tareaRelanzar = null;
		Collections.reverse(listaTareas);
		for (int i = 0; i < listaTareas.size(); i++) {
			tarea = listaTareas.get(i);
			if (tarea.getError() != null) {
				tipoTarea = tarea.getTipoTarea().getTaskId090();
				error = tarea.getError();
				if ((i + 1) < listaTareas.size()) {
					tareaRelanzar = listaTareas.get(i + 1);
					if (tareaRelanzar.getEstado063() == EstadosTareas.INICIADA
							.getEstado()
							&& tareaRelanzar.getTipoTarea().getTaskId090()
									.equals(tipoTarea)) {
						tareaRelanzar.setRelanzar("si");
						tareaRelanzar.setError(error);
					}
				}

			}
		}
		Collections.reverse(listaTareas);

	}

	/**
	 * Gets the tab estado doc.
	 * 
	 * model Model terape String anoape String numape Long request
	 * HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param request
	 *            the request the tab estado doc
	 * @return the tab estado doc
	 */
	@RequestMapping(value = "/tabDatosEstadoDoc/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabEstadoDoc(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape,
			HttpServletRequest request) {

		// cargamos apertura
		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFindDetalle(apertura);

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		// Preparo la configuración de las opciones de tramitación
		// Preparo la configuración de las opciones de tramitación
		String modoAcceso = (String) request.getSession().getAttribute(
				ComunicacionAperturaController.ATTR_NAME_MODO_ACCESO);
		String toolbarDatosEstado = this.preparaToolbarDatosEstado(apertura,
				modoAcceso);
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_ESTADO,
				toolbarDatosEstado);

		return "tabDatosEstadoDoc";
	}

	/**
	 * Modifica los datos de la pestaña de EstadoOS2 del expediente.
	 * 
	 * comunicacionApertura ComunicacionApertura Bean que contiene la
	 * informacion con la que se va a crear el nuevo registro. Denuncia Bean
	 * resultante del proceso de creacion.
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/tabDatosEstadoDoc/modificar", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura modificarTabDatosEstadoDoc(
			@RequestBody() ComunicacionApertura comunicacionApertura) {

		this.comunicAperturaService
				.modificarDatosTabEstadoDoc(comunicacionApertura);

		ComunicacionAperturaController.LOGGER
				.info("[POST] : Expediente modificado correctamente");
		return comunicacionApertura;
	}

	/**
	 * Gets the tab historico.
	 * 
	 * model Model terape String anoape String numape Long String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the tab historico
	 * @return the tab historico
	 */
	@RequestMapping(value = "/tabHistorico/{terape}/{anoape}/{numape}", method = RequestMethod.GET)
	public String getTabHistorico(Model model, @PathVariable() String terape,
			@PathVariable() String anoape, @PathVariable() Long numape) {

		Locale locale = LocaleContextHolder.getLocale();
		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.find(apertura);

		HistCambiosAperturas histCambiosFind = new HistCambiosAperturas();

		List<HistCambiosAperturas> listaCambiosApertura = new ArrayList<HistCambiosAperturas>();

		if (apertura.getIdape056() != null && apertura.getIdape056() > 0) {

			histCambiosFind.setIdape087(apertura.getIdape056());

			listaCambiosApertura = this.histCambiosAperturasService
					.findAllConComparador(histCambiosFind, null,
							locale.getLanguage());
		}
		apertura.setListaHistoricoCambios(listaCambiosApertura);

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		return "tabHistorico";
	}

	/**
	 * Prepara toolbar tramitacion.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarTramitacion(ComunicacionApertura apertura,
			String modoAcceso) throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		Boton botonAccionesDisponibles = new Boton("accionesdisponibles",
				"accionesdisponibles");
		List<Boton> listaBotonesAccionesDisponibles = new ArrayList<Boton>();
		if (Constantes.MODO_ACCESO_MANTENIMIENTO.equals(modoAcceso)) {

			// Abrir expediente
			listaBotonesAccionesDisponibles
					.add(new Boton("reabrirExpediente", "abrirExpediente"));

			// Estudio de documentación
			if (this.validadorBotonera.validarBotonEstudioDocumentacion()) {
				listaBotonesAccionesDisponibles.add(new Boton(
						"estudiodocumentacion", "estudiodocumentacion"));
			}
			// Cerrar expediente
			listaBotonesAccionesDisponibles
					.add(new Boton("cerrarExpediente", "cerrarExpediente"));
		}

		if (!listaBotonesAccionesDisponibles.isEmpty()) {
			botonAccionesDisponibles
					.setButtons(listaBotonesAccionesDisponibles);
		}
		botonera.addBoton(botonAccionesDisponibles);

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Prepara toolbar prod almac.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarProdAlmac(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar notificacion.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarNotificacion(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar datos empresa.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarDatosEmpresa(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar datos centro.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarDatosCentro(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar datos estado.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarDatosEstado(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar datos obra.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarDatosObra(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (!Constantes.MODO_ACCESO_CONSULTA.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Prepara toolbar documentos.
	 * 
	 * apertura ComunicacionApertura modoAcceso String String
	 * 
	 * @param apertura
	 *            the apertura
	 * @param modoAcceso
	 *            the modo acceso the string
	 * @return the string
	 */
	private String preparaToolbarDocumentos(ComunicacionApertura apertura,
			String modoAcceso) {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		if (Constantes.MODO_ACCESO_MANTENIMIENTO.equals(modoAcceso)
				|| Constantes.MODO_ACCESO_INSPECCION.equals(modoAcceso)) {
			botonera.addBoton(new Boton("guardar", "guardar"));
		}
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "{buttons: []}";
		}
	}

	/**
	 * Acceder detalle tarea sugerida.
	 * 
	 * idTarea Long model Model String
	 * 
	 * @param idTarea
	 *            the id tarea
	 * @param model
	 *            the model the string
	 * @return the string
	 */
	@RequestMapping(value = "/task/{idTarea}")
	public String accederDetalleTareaSugerida(
			@PathVariable(value = "idTarea") Long idTarea, Model model) {

		TareaAperturas tarea = new TareaAperturas(idTarea);
		tarea = this.tareaAperturaService.findTareaTramite(tarea);

		ComunicacionApertura apertura = this.comunicAperturaService
				.find(tarea.getTramiteAperturas().getApertura());

		String tiles = "";
		String toolbarTramitacion = "";

		if (TipoTareaFlujo.ESTUDIO
				.esEquivalente(tarea.getTipoTarea().getTaskId090())) {
			tiles = "estudio";

			// Obtenemos el estudio de documentación de la tarea
			EstudioDocAperturas estudio = new EstudioDocAperturas();
			estudio.setTareaAperturas(tarea);
			estudio = this.estudioDocAperturasService.find(estudio);

			if (estudio == null) {
				// Si no existe, lo creamos
				estudio = new EstudioDocAperturas(tarea);
				this.estudioDocAperturasService.add(estudio);
			}

			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_ESTUDIO,
					estudio);

			try {
				toolbarTramitacion = this.preparaToolbarEstudio();
			} catch (Exception e) {
				ComunicacionAperturaController.LOGGER
						.error("Error al generar el toolbar de estudio", e);
				toolbarTramitacion = "{buttons: []}";
			}
		} else if (TipoTareaFlujo.ADJUNTAR_DOC_REQUERIMIENTO
				.esEquivalente(tarea.getTipoTarea().getTaskId090())) {
			tiles = "requerimiento";

			// Obtenemos los motivos de subsanacion
			Tablones tablones = new Tablones();
			tablones.setCodtabla088(Constantes.TABLON_MOTIVOS_SUBSANACION);
			JQGridRequestDto jqgrid = new JQGridRequestDto();
			jqgrid.setSidx("CODIGO088");
			jqgrid.setSord("ASC");
			List<Tablones> listaMotivos = this.tablonesService.findAll(tablones,
					jqgrid);

			// Obtenemos el requerimiento de la tarea
			RequerimientoAperturas requerimiento = new RequerimientoAperturas();
			requerimiento.setTareaAperturas(tarea);
			List<RequerimientoAperturas> listaMotivosReq = this.requerimientoAperturasService
					.findAll(requerimiento, null);

			String descOtrosEs = "";
			String descOtrosEu = "";

			if (listaMotivosReq != null && listaMotivosReq.size() > 0) {
				for (Tablones tipoMotivo : listaMotivos) {
					for (RequerimientoAperturas motivoReq : listaMotivosReq) {
						if (motivoReq.getMotivo058()
								.equals(tipoMotivo.getCodigo088())) {
							tipoMotivo.setSelected(true);
							break;
						}
					}
				}
				// Recogemos la descripcion del motivo 'Otros'
				for (RequerimientoAperturas motivoReq : listaMotivosReq) {
					if (motivoReq.getMotivo058()
							.equals(Constantes.MOTIVO_SUBSANACION_OTROS)) {
						descOtrosEs = motivoReq.getDescOtrosEu058() != null
								? motivoReq.getDescOtrosEu058() : "";

						descOtrosEu = motivoReq.getDescOtrosEu058() != null
								? motivoReq.getDescOtrosEu058() : "";
						break;
					}
				}
			}

			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_REQUERIMIENTO,
					requerimiento);
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DESC_OTROS_ES,
					descOtrosEs);
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DESC_OTROS_EU,
					descOtrosEu);
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_LISTA_MOTIVOS_REQ,
					listaMotivos);

			try {
				toolbarTramitacion = this.preparaToolbarRequerimiento();
			} catch (Exception e) {
				ComunicacionAperturaController.LOGGER.error(
						"Error al generar el toolbar de requerimiento", e);
				toolbarTramitacion = "{buttons: []}";
			}
		} else if (TipoTareaFlujo.ADJUNTAR_INFORME
				.esEquivalente(tarea.getTipoTarea().getTaskId090())) {

			tiles = "adjuntarInformeVisita";

			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TAREA,
					tarea.getIdTarea063());

			model.addAttribute("autoridades",
					UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_VOSALANOS4OS6_FILTER,
					new VosalanOs4Os6());

			try {
				toolbarTramitacion = this.preparaToolbarVisita();
			} catch (Exception e) {
				ComunicacionAperturaController.LOGGER
						.error("Error al generar el toolbar de estudio", e);
				toolbarTramitacion = "{buttons: []}";
			}
		}

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_TRAMITACION,
				toolbarTramitacion);

		return tiles;
	}

	/**
	 * Prepara toolbar estudio.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarEstudio()
			throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		Boton botonConsolidar = new Boton("consolidar", "consolidar");
		botonera.addBoton(botonConsolidar);

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Prepara toolbar requerimiento.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarRequerimiento()
			throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		Boton botonPrev = new Boton("previsualizar", "previsualizar");
		botonera.addBoton(botonPrev);
		Boton botonGenerar = new Boton("generar", "generar");
		botonera.addBoton(botonGenerar);

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Prepara toolbar visita.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarVisita()
			throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Prepara toolbar visita masiva.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarVisitaMasiva()
			throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		Boton botonMarcarVisita = new Boton("marcarVisitaOsalan",
				"marcarVisitaOsalan");
		botonera.addBoton(botonMarcarVisita);

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Prepara toolbar cambio coordinador.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 * @throws JsonMappingException
	 *             al parsear objeto a json
	 * @throws IOException
	 *             al parsear objeto a json
	 */
	private String preparaToolbarCambioCoordinador()
			throws JsonMappingException, IOException {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();

		Boton botonConsolidar = new Boton("cambiocoordinador",
				"cambiocoordinador");
		botonera.addBoton(botonConsolidar);

		return mapper.writeValueAsString(botonera);
	}

	/**
	 * Consolidar estudio documentacion.
	 * 
	 * estudio EstudioDocAperturas String DOCU_CORRECTA o REQ_SUBSANA
	 * 
	 * @param estudio
	 *            the estudio the string
	 * @return the string
	 */
	@RequestMapping(value = "/consolidarEstudio", method = RequestMethod.POST)
	public @ResponseBody() String consolidarEstudioDocumentacion(
			@RequestBody() EstudioDocAperturas estudio) {

		if (Utilities.getInstance().isEmpty(estudio.getResultado064())) {
			throw new ErrorGenericoException("estudio.resultado",
					"validacion.obligatorio");
		}

		// Actualizamos el estudio en BD
		this.estudioDocAperturasService.update(estudio);

		estudio.setTareaAperturas(
				this.tareaAperturaService.find(estudio.getTareaAperturas()));

		// Tramitamos el estudio
		this.tramitacionAperturasService.tramitarEstudioDocumentacion(estudio);

		// Marcamos la tarea como iniciada (solo si está en estado SUGERIDA,
		// no sea que haya llegado antes el evento de EJECUTADA)
		TareaAperturas tarea = this.tareaAperturaService
				.findTareaTramite(estudio.getTareaAperturas());
		if (EstadosTareas.SUGERIDA.getEstado().equals(tarea.getEstado063())) {
			tarea.setEstado063(EstadosTareas.INICIADA.getEstado());
			this.tareaAperturaService.updateFilled(tarea);
		}

		ComunicacionApertura apertura = new ComunicacionApertura(
				tarea.getTramiteAperturas().getApertura().getTerape056(),
				tarea.getTramiteAperturas().getApertura().getAnoape056(),
				tarea.getTramiteAperturas().getApertura().getNumape056());
		apertura.setUsuarioTram(
				UtilSeguridad.getInstance().getUserCredentials().getPosition());
		this.comunicAperturaService.updateUsuariosTramitacion(apertura);

		return estudio.getResultado064();
	}

	/**
	 * Cambiarcoordinador.
	 * 
	 * listaco the listaco boolean
	 * 
	 * @param listaco
	 *            the listaco the string
	 * @return the string
	 */
	@RequestMapping(value = "/cambiarcoordinador", method = RequestMethod.POST)
	public @ResponseBody() String cambiarcoordinador(
			@RequestBody() CoordinadorObra[] listaco) {

		CoordinadorObra coordinador_anterior = listaco[0];
		String ter = coordinador_anterior.getTerexp084();
		String ano = coordinador_anterior.getAnoexp084();
		Integer num = coordinador_anterior.getNumexp084();

		CoordinadorObra coordinador_nuevo = listaco[1];

		// Validate
		List<ErrorField> errores = this.validateCambioCoordinador(
				coordinador_anterior, coordinador_nuevo);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObra
				.findAll(coordinador_nuevo, null);

		if (listaCoordinadores != null && !listaCoordinadores.isEmpty()) {
			errores.add(new ErrorField("aperturas.detalle.coordinadorE",
					"error.coordinadorE.activo"));

			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}
		}

		coordinador_anterior = this.coordinadorObra.find(coordinador_anterior);
		coordinador_nuevo.setCodobra084(coordinador_anterior.getCodobra084());
		this.coordinadorObra.remove(coordinador_anterior);
		this.coordinadorObra.add(coordinador_nuevo);

		ComunicacionApertura apertura = new ComunicacionApertura(ter, ano,
				num.longValue());
		apertura = this.comunicAperturaService.vFindDetalle(apertura);

		coordinadorObra.modificarHistorico(coordinador_anterior,
				coordinador_nuevo, apertura);

		try {

			apertura.setUsuarioTram(UtilSeguridad.getInstance()
					.getUserCredentials().getPosition());
			this.comunicAperturaService.updateUsuariosTramitacion(apertura);

			this.plateaTramitacionService.crearTarea(
					Utilities.getInstance().obtenerProcedureIdApertura(),
					TipoTramiteFlujo.CAMBIAR_COORDINADOR.name(),
					TipoTareaFlujo.ADJUNTAR_CARTA_CAMBIO_COORDINADOR_CONTRATISTA
							.getTaskId(),
					apertura.getFolderId056(),
					UtilSeguridad.getInstance().getUserCredentials()
							.getPosition(),
					UtilSeguridad.getInstance().getNombre());
		} catch (Exception e) {
			return "ko";
		}

		return "ok";
	}

	/**
	 * Generar documento requerimiento.
	 * 
	 * listaTiposDoc List<String> idTarea Long descOtrosEs String descOtrosEu
	 * String String
	 * 
	 * @param listaTiposDoc
	 *            the lista tipos doc
	 * @param idTarea
	 *            the id tarea
	 * @param descOtrosEs
	 *            the desc otros es
	 * @param descOtrosEu
	 *            the desc otros eu the string
	 * @return the string
	 */
	@RequestMapping(value = "/generarDocumentoRequerimiento", method = RequestMethod.GET)
	public @ResponseBody() String generarDocumentoRequerimiento(
			@RequestParam(value = "docRequerimiento", required = false) List<String> listaTiposDoc,
			@RequestParam(value = "idTarea", required = false) Long idTarea,
			@RequestParam(value = "descOtrosEs", required = false) String descOtrosEs,
			@RequestParam(value = "descOtrosEu", required = false) String descOtrosEu) {

		if (!(listaTiposDoc.size() > 0)) {
			throw new ErrorGenericoException("requerimiento.motivos",
					"error.motivos.subsanacion");
		}
		this.requerimientoAperturasService.removePorTarea(idTarea);

		// Actualizamos el requerimiento en BD
		TareaAperturas tarea = new TareaAperturas(idTarea);
		for (int i = 0; i < listaTiposDoc.size(); i++) {
			RequerimientoAperturas requerimiento = new RequerimientoAperturas();
			requerimiento.setTareaAperturas(tarea);
			requerimiento.setMotivo058(listaTiposDoc.get(i));
			if (listaTiposDoc.get(i)
					.equals(Constantes.MOTIVO_SUBSANACION_OTROS)) {
				requerimiento.setDescOtrosEs058(descOtrosEs);
				requerimiento.setDescOtrosEu058(descOtrosEu);
			}
			this.requerimientoAperturasService.add(requerimiento);
		}

		tarea = this.tareaAperturaService.findTareaTramite(tarea);

		TramiteAperturas tramite = new TramiteAperturas(
				tarea.getTramiteAperturas().getIdTramite062());
		tramite = this.tramiteAperturaService.find(tramite);

		ComunicacionApertura apertura = new ComunicacionApertura(
				tramite.getApertura().getTerape056(),
				tramite.getApertura().getAnoape056(),
				tramite.getApertura().getNumape056());
		apertura.setUsuarioTram(
				UtilSeguridad.getInstance().getUserCredentials().getPosition());
		this.comunicAperturaService.updateUsuariosTramitacion(apertura);

		apertura = this.comunicAperturaService.find(apertura);

		tramite.setApertura(apertura);
		tarea.setTramiteAperturas(tramite);

		try {
			this.tramitacionAperturasService.prepararDocRequerimiento(tarea);
		} catch (Exception e) {
			ComunicacionAperturaController.LOGGER
					.error("Error al generar el documento de requerimiento", e);
		}

		// Marcamos la tarea como iniciada (solo si está en estado SUGERIDA,
		// no sea que haya llegado antes el evento de EJECUTADA)
		if (EstadosTareas.SUGERIDA.getEstado().equals(tarea.getEstado063())) {
			tarea.setEstado063(EstadosTareas.INICIADA.getEstado());
			this.tareaAperturaService.updateFilled(tarea);
		}

		return "";
	}

	/**
	 * Generar documento requerimiento.
	 * 
	 * listaTiposDoc List<String> idTarea Long descOtrosEs String descOtrosEu
	 * String String
	 * 
	 * @param listaTiposDoc
	 *            the lista tipos doc
	 * @param idTarea
	 *            the id tarea
	 * @param descOtrosEs
	 *            the desc otros es
	 * @param descOtrosEu
	 *            the desc otros eu the string
	 * @throws AB04BException
	 * @throws IOException
	 */
	@RequestMapping(value = "/prevDocumentoRequerimiento", method = RequestMethod.GET)
	public void prevDocumentoRequerimiento(
			@RequestParam(value = "docRequerimiento", required = false) List<String> listaTiposDoc,
			@RequestParam(value = "idTarea", required = false) Long idTarea,
			@RequestParam(value = "descOtrosEs", required = false) String descOtrosEs,
			@RequestParam(value = "descOtrosEu", required = false) String descOtrosEu,
			HttpServletResponse response) throws AB04BException, IOException {

		if (!(listaTiposDoc.size() > 0)) {
			throw new ErrorGenericoException("requerimiento.motivos",
					"error.motivos.subsanacion");
		}

		this.requerimientoAperturasService.removePorTarea(idTarea);

		// // Actualizamos el requerimiento en BD
		TareaAperturas tarea = new TareaAperturas(idTarea);
		for (int i = 0; i < listaTiposDoc.size(); i++) {
			RequerimientoAperturas requerimiento = new RequerimientoAperturas();
			requerimiento.setTareaAperturas(tarea);
			requerimiento.setMotivo058(listaTiposDoc.get(i));
			if (listaTiposDoc.get(i)
					.equals(Constantes.MOTIVO_SUBSANACION_OTROS)) {
				requerimiento.setDescOtrosEs058(descOtrosEs);
				requerimiento.setDescOtrosEu058(descOtrosEu);
			}
			this.requerimientoAperturasService.add(requerimiento);
		}

		tarea = this.tareaAperturaService.findTareaTramite(tarea);

		TramiteAperturas tramite = new TramiteAperturas(
				tarea.getTramiteAperturas().getIdTramite062());
		tramite = this.tramiteAperturaService.find(tramite);

		ComunicacionApertura apertura = new ComunicacionApertura(
				tramite.getApertura().getTerape056(),
				tramite.getApertura().getAnoape056(),
				tramite.getApertura().getNumape056());
		apertura.setUsuarioTram(
				UtilSeguridad.getInstance().getUserCredentials().getPosition());
		this.comunicAperturaService.updateUsuariosTramitacion(apertura);

		apertura = this.comunicAperturaService.find(apertura);

		tramite.setApertura(apertura);
		tarea.setTramiteAperturas(tramite);

		String foldernumber = tarea.getTramiteAperturas().getApertura()
				.getNumExpediente();

		InputStream is = this.generacionPDFSubsanacionService.getPDF(
				foldernumber, ConstantesDocumentos.APERTURA_CENTRO,
				tramite.getIdTramite062());

		response.setContentType("application/pdf");
		// response.addHeader("Content-Disposition",
		// "attachment; filename=Requerimiento.pdf");

		FileCopyUtils.copy(is, response.getOutputStream());

		response.flushBuffer();
	}

	/**
	 * Adjuntar informe visita.
	 * 
	 * tipoos String codctr String numdoc String codano String codpro String
	 * numeje String fecvisStr String codtec String numexp String idTareaStr
	 * String String
	 * 
	 * @param tipoos
	 *            the tipoos
	 * @param codctr
	 *            the codctr
	 * @param numdoc
	 *            the numdoc
	 * @param codano
	 *            the codano
	 * @param codpro
	 *            the codpro
	 * @param numeje
	 *            the numeje
	 * @param fecvisStr
	 *            the fecvis str
	 * @param codtec
	 *            the codtec
	 * @param numexp
	 *            the numexp
	 * @param idTareaStr
	 *            the id tarea str the string
	 * @return the string
	 */
	@RequestMapping(value = "/adjuntarInformeVisita", method = RequestMethod.GET)
	public @ResponseBody() String adjuntarInformeVisita(
			@RequestParam(value = "tipoos", required = false) String tipoos,
			@RequestParam(value = "codctr", required = false) String codctr,
			@RequestParam(value = "numdoc", required = false) String numdoc,
			@RequestParam(value = "codano", required = false) String codano,
			@RequestParam(value = "codpro", required = false) String codpro,
			@RequestParam(value = "numeje", required = false) String numeje,
			@RequestParam(value = "fecvis", required = false) String fecvisStr,
			@RequestParam(value = "codtec", required = false) String codtec,
			@RequestParam(value = "numexp", required = false) String numexp,
			@RequestParam(value = "idTarea", required = false) String idTareaStr) {

		Long idTarea = Long.valueOf(idTareaStr);
		TareaAperturas tarea = new TareaAperturas(idTarea);

		DateFormat df = new SimpleDateFormat(
				Constantes.CTE_MASCARA_FECHA_DIA_MES_ANO);
		Date fecvis = null;

		try {
			fecvis = df.parse(fecvisStr);

			VosalanOs4Os6 visita = new VosalanOs4Os6(tipoos,
					Integer.valueOf(codctr), Integer.valueOf(numdoc),
					Long.valueOf(codano), codpro, Integer.valueOf(numeje),
					fecvis, codtec, Integer.valueOf(numexp));
			visita = this.vosalanOs4Os6Service.find(visita);

			tarea = this.tareaAperturaService.findTareaTramite(tarea);

			TramiteAperturas tramite = new TramiteAperturas(
					tarea.getTramiteAperturas().getIdTramite062());
			tramite = this.tramiteAperturaService.find(tramite);

			ComunicacionApertura apertura = new ComunicacionApertura(
					tramite.getApertura().getTerape056(),
					tramite.getApertura().getAnoape056(),
					tramite.getApertura().getNumape056());
			apertura = this.comunicAperturaService.find(apertura);

			tramite.setApertura(apertura);
			tarea.setTramiteAperturas(tramite);

			apertura.setUsuarioTram(UtilSeguridad.getInstance()
					.getUserCredentials().getPosition());
			this.comunicAperturaService.updateUsuariosTramitacion(apertura);

			this.tramitacionAperturasService.prepararDocVisitaOsalan(tarea,
					visita);
		} catch (Exception e) {
			ComunicacionAperturaController.LOGGER.error(
					"Error al generar el documento de visita de Osalan", e);
		}

		// Marcamos la tarea como iniciada (solo si está en estado SUGERIDA,
		// no sea que haya llegado antes el evento de EJECUTADA)
		if (EstadosTareas.SUGERIDA.getEstado().equals(tarea.getEstado063())) {
			tarea.setEstado063(EstadosTareas.INICIADA.getEstado());
			this.tareaAperturaService.updateFilled(tarea);
		}

		return "";
	}

	/**
	 * Cerrar expediente.
	 * 
	 * model Model terape String anoape String numape Long String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the string
	 * @return the string
	 */
	@RequestMapping(value = "/cerrarExpediente/{terape}/{anoape}/{numape}", method = RequestMethod.POST)
	public @ResponseBody() String cerrarExpediente(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) {

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFind(apertura);

		List<ErrorField> errores = new ArrayList<ErrorField>();
		if (gatService
				.obtenerCountTareasPendientes(apertura.getFolderId056()) == 0) {
			try {

				apertura.setEstado056("P");
				this.comunicAperturaService.updateCierreTemporal(apertura);
				this.plateaTramitacionService.crearTarea(
						Utilities.getInstance().obtenerProcedureIdApertura(),
						TipoTramiteFlujo.CIERRE.name(),
						TipoTareaFlujo.CIERRE.getTaskId(),
						apertura.getFolderId056(),
						UtilSeguridad.getInstance().getUserCredentials()
								.getPosition(),
						UtilSeguridad.getInstance().getNombre());

				// Metemos la entidad Comunicación de apertura al modelo
				model.addAttribute(
						ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
						apertura);

			} catch (Exception e) {
				apertura.setEstado056("A");
				this.comunicAperturaService.updateCierreTemporal(apertura);
				errores.add(new ErrorField(apertura.getNumExpediente(),
						"error.cierre"));
			}
		} else {
			errores.add(new ErrorField(apertura.getNumExpediente(),
					"error.cierre.pendiente"));
		}
		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				apertura);

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return "tabTramitacion";
	}

	/**
	 * Cerrar expediente masivo.
	 * 
	 * model Model expedientes the expedientes String
	 * 
	 * @param model
	 *            the model
	 * @param expedientes
	 *            the expedientes the string
	 * @return the string
	 */
	@RequestMapping(value = "/cerrarExpedienteMasivo", method = RequestMethod.POST)
	public @ResponseBody() String cerrarExpedienteMasivo(Model model,
			@RequestBody() ComunicacionApertura[] expedientes) {

		List<ErrorField> errores = new ArrayList<ErrorField>();
		for (ComunicacionApertura apertura : expedientes) {
			apertura = this.comunicAperturaService.vFind(apertura);
			if ("A".equals(apertura.getEstado056())) {

				if (gatService.obtenerCountTareasPendientes(
						apertura.getFolderId056()) == 0) {
					try {

						apertura.setEstado056("P");
						this.comunicAperturaService
								.updateCierreTemporal(apertura);
						this.plateaTramitacionService.crearTarea(
								Utilities.getInstance()
										.obtenerProcedureIdApertura(),
								TipoTramiteFlujo.CIERRE.name(),
								TipoTareaFlujo.CIERRE.getTaskId(),
								apertura.getFolderId056(),
								UtilSeguridad.getInstance().getUserCredentials()
										.getPosition(),
								UtilSeguridad.getInstance().getNombre());

						// Metemos la entidad Comunicación de apertura al modelo
						model.addAttribute(
								ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
								apertura);

					} catch (Exception e) {
						apertura.setEstado056("A");
						this.comunicAperturaService
								.updateCierreTemporal(apertura);
						errores.add(new ErrorField(apertura.getNumExpediente(),
								"error.cierre"));
					}
				} else {
					errores.add(new ErrorField(apertura.getNumExpediente(),
							"error.cierre.pendiente"));
				}
			}
		}

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return "ok";
	}

	/**
	 * Borrar apertura.
	 * 
	 * model Model terape String anoape String numape Long motivo the motivo
	 * String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param motivo
	 *            the motivo the string
	 * @return the string
	 */
	@RequestMapping(value = "/borrarApertura/{terape}/{anoape}/{numape}", method = RequestMethod.POST)
	public @ResponseBody() String borrarApertura(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape,
			@RequestParam(value = "motivo", required = false) String motivo) {

		List<ErrorField> errores = new ArrayList<ErrorField>();

		ComunicacionApertura apertura = new ComunicacionApertura(terape, anoape,
				numape);
		apertura = this.comunicAperturaService.vFind(apertura);

		if ("A".equals(apertura.getEstado056())) {

			if (gatService.obtenerCountTareasPendientes(
					apertura.getFolderId056()) == 0) {
				try {

					apertura.setEstado056("E");
					this.comunicAperturaService.updateFilled(apertura);

					this.plateaTramitacionService.crearTarea(
							Utilities.getInstance()
									.obtenerProcedureIdApertura(),
							TipoTramiteFlujo.CIERRE.name(),
							TipoTareaFlujo.CIERRE.getTaskId(),
							apertura.getFolderId056(),
							UtilSeguridad.getInstance().getUserCredentials()
									.getPosition(),
							UtilSeguridad.getInstance().getNombre());

					// Metemos la entidad Comunicación de apertura al modelo
					model.addAttribute(
							ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
							apertura);

					String comunicacionAperturaOldStr = HistCambiosAperturasUtil
							.concatenarCamposEliminar(
									new ComunicacionApertura());

					apertura.setUsumod056(UtilSeguridad.getInstance().getNif());
					apertura.setFecmod056(new Date());
					apertura.setMotivoBaja(motivo);
					String comunicacionAperturaNewStr = HistCambiosAperturasUtil
							.concatenarCamposEliminar(apertura);

					HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
					histCambioAperturas.setIdape087(apertura.getIdape056());
					if (apertura.getMigrado056() != null && Constantes.VALUE_SI
							.equals(apertura.getMigrado056())) {
						histCambioAperturas
								.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
					} else {
						histCambioAperturas
								.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
					}

					histCambioAperturas
							.setRegoriginal087(comunicacionAperturaOldStr);
					histCambioAperturas.setRegmidificaciones087(
							comunicacionAperturaNewStr);
					histCambioAperturas.setFecmodif087(new Date());
					histCambioAperturas.setTipocambio087(
							TipoCambio.ELIMINACION_APERTURA.getCodigo());

					this.histCambiosAperturasService.add(histCambioAperturas);

				} catch (Exception e) {
					apertura.setEstado056("A");
					this.comunicAperturaService.updateCierreTemporal(apertura);
					errores.add(new ErrorField(apertura.getNumExpediente(),
							"error.cierre"));
				}
			} else {
				errores.add(new ErrorField(apertura.getNumExpediente(),
						"error.cierre.pendiente"));
			}
		}

		if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		return "ok";
	}

	/**
	 * Crear estudio documentacion.
	 * 
	 * model Model terape String anoape String numape Long String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the string
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/reabrirExpediente/{terape}/{anoape}/{numape}", method = RequestMethod.POST)
	public @ResponseBody() String reabrirExpediente(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) throws AB04BException {
		try {
			ComunicacionApertura apertura = new ComunicacionApertura(terape,
					anoape, numape);
			apertura = this.comunicAperturaService.vFind(apertura);

			this.plateaTramitacionService.crearTarea(
					Utilities.getInstance().obtenerProcedureIdApertura(),
					TipoTramiteFlujo.APERTURA.name(),
					TipoTareaFlujo.APERTURA.getTaskId(),
					apertura.getFolderId056(),
					UtilSeguridad.getInstance().getUserCredentials()
							.getPosition(),
					UtilSeguridad.getInstance().getNombre());

			// Metemos la entidad Comunicación de apertura al modelo
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);

			return "tabTramitacion";
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Crear estudio documentacion.
	 * 
	 * model Model terape String anoape String numape Long String
	 * 
	 * @param model
	 *            the model
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape the string
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/crearEstudioDocumentacion/{terape}/{anoape}/{numape}", method = RequestMethod.POST)
	public @ResponseBody() String crearEstudioDocumentacion(Model model,
			@PathVariable() String terape, @PathVariable() String anoape,
			@PathVariable() Long numape) throws AB04BException {
		try {
			ComunicacionApertura apertura = new ComunicacionApertura(terape,
					anoape, numape);
			apertura = this.comunicAperturaService.vFind(apertura);

			this.plateaTramitacionService.crearTarea(
					Utilities.getInstance().obtenerProcedureIdApertura(),
					TipoTramiteFlujo.ESTUDIO.name(),
					TipoTareaFlujo.ESTUDIO.getTaskId(),
					apertura.getFolderId056(),
					UtilSeguridad.getInstance().getUserCredentials()
							.getPosition(),
					UtilSeguridad.getInstance().getNombre());

			// Metemos la entidad Comunicación de apertura al modelo
			model.addAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
					apertura);

			return "tabTramitacion";
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Machacha los IDs del objeto comIni (que nos viene de la request con IDs
	 * vacÃ­os) con los que estÃ¡n guardados en el objeto comIniIds, que es el
	 * que estÃ¡ en session con todos los IDs.
	 * 
	 * exp Expedientes expIds Expedientes
	 * 
	 * @param exp
	 *            the exp
	 * @param expIds
	 *            the exp ids
	 */
	private void machacarIdsDatosApertura(ComunicacionApertura exp,
			ComunicacionApertura expIds) {
		// Id expediente
		exp.setTerape056(expIds.getTerape056());
		exp.setAnoape056(expIds.getAnoape056());
		exp.setNumape056(expIds.getNumape056());

		// Id datos notificación solicitante
		if (exp.getDatosNotificacion() == null) {
			exp.setDatosNotificacion(new DatosNotificacion());
		}
		exp.getDatosNotificacion().setCodDatosNotif066(
				expIds.getDatosNotificacion().getCodDatosNotif066());

		// Id localización nora solicitante (direcciÃ³n)
		if (exp.getDatosNotificacion().getDatosLocalizacion() == null) {
			exp.getDatosNotificacion()
					.setDatosLocalizacion(new DatosLocalizacion());
		}

		if (expIds.getDatosNotificacion().getDatosLocalizacion() != null) {
			exp.getDatosNotificacion().getDatosLocalizacion()
					.setCodLocalizacion067(expIds.getDatosNotificacion()
							.getDatosLocalizacion().getCodLocalizacion067());

		}
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * listado String request HttpServletRequest response HttpServletResponse
	 * the carta apertura PDF
	 * 
	 * @param listado
	 *            the listado
	 * @param request
	 *            the request
	 * @param response
	 *            the response the carta apertura PDF
	 * @return the carta apertura PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */

	@RequestMapping(value = "cartaAperturaPDF/{listado}", method = RequestMethod.GET)
	public @ResponseBody void getCartaAperturaPDF(
			@PathVariable() String listado, HttpServletRequest request,
			HttpServletResponse response) throws AB04BException {
		try {
			String[] seleccion = listado.split(",");
			String[] selecFrom = obtenerNumerosApertura(seleccion);
			InputStream is = this.generacionPDFCartaAperturaService
					.getPDF(selecFrom);

			response.setContentType("application/pdf");

			IOUtils.copy(is, response.getOutputStream());
			is.close();
			response.getOutputStream().close();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * listado String request HttpServletRequest response HttpServletResponse
	 * the carta os 2 PDF
	 * 
	 * @param listado
	 *            the listado
	 * @param request
	 *            the request
	 * @param response
	 *            the response the carta os 2 PDF
	 * @return the carta os 2 PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */

	@RequestMapping(value = "cartaOs2/{listado}", method = RequestMethod.GET)
	public @ResponseBody void getCartaOs2PDF(@PathVariable() String listado,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			String[] seleccion = listado.split(",");
			String[] selecFrom = obtenerNumerosApertura(seleccion);
			InputStream is = this.generacionPDFComunicacionOS2Service
					.getPDF(selecFrom);

			response.setContentType("application/pdf");

			IOUtils.copy(is, response.getOutputStream());
			is.close();
			response.getOutputStream().close();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Realiza la exportaciÃ³n a Pdf.
	 * 
	 * listado String request HttpServletRequest response HttpServletResponse
	 * the carta os 3 PDF
	 * 
	 * @param listado
	 *            the listado
	 * @param request
	 *            the request
	 * @param response
	 *            the response the carta os 3 PDF
	 * @return the carta os 3 PDF
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */

	@RequestMapping(value = "cartaOs3/{listado}", method = RequestMethod.GET)
	public @ResponseBody void getCartaOs3PDF(@PathVariable() String listado,
			HttpServletRequest request, HttpServletResponse response)
			throws AB04BException {
		try {
			String[] seleccion = listado.split(",");
			String[] selecFrom = obtenerNumerosApertura(seleccion);
			InputStream is = this.generacionPDFComunicacionOS2OS3Service
					.getPDF(selecFrom);

			response.setContentType("application/pdf");

			IOUtils.copy(is, response.getOutputStream());
			is.close();
			response.getOutputStream().close();
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Devuelve los numeros de apertura seleccionados.
	 * 
	 * seleccion String[] String[]
	 * 
	 * @param seleccion
	 *            the seleccion the string[]
	 * @return the string[]
	 */
	private String[] obtenerNumerosApertura(String[] seleccion) {
		String[] selecFrom = new String[seleccion.length];

		for (int i = 0; i < seleccion.length; i++) {
			String[] spl = seleccion[i].split("~");
			selecFrom[i] = spl[0] + "-" + spl[1] + "-"
					+ StringUtils.leftPad(spl[ConstantesNum.NUM_2],
							ComunicacionAperturaController.NUMEXP_LPAD_SIZE,
							ComunicacionAperturaController.NUMEXP_LPAD_CHAR);
		}

		return selecFrom;
	}

	/**
	 * Validate cambio coordinador.
	 * 
	 * coordinador_anterior CoordinadorObra coordinador_nuevo the coordinador
	 * nuevo List<ErrorField>
	 * 
	 * @param coordinador_anterior
	 *            the coordinador anterior
	 * @param coordinador_nuevo
	 *            the coordinador nuevo the list
	 * @return the list
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity
	private List<ErrorField> validateCambioCoordinador(
			CoordinadorObra coordinador_anterior,
			CoordinadorObra coordinador_nuevo) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();

		if (coordinador_anterior.getNumexp084() == null) {
			errorFields.add(new ErrorField("", "error.seleccionarcoordinador"));
		}

		if (coordinador_nuevo.getTipdoc084() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.tipoIdentif",
					"error.tipocifnif"));
		}

		if (coordinador_nuevo.getNumdoc084() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"validacion.obligatorio"));

		} else if (coordinador_nuevo.getNumdoc084() != null
				&& Constantes.TIPO_CIF.equals(coordinador_nuevo.getTipdoc084())
				&& !ValidadorNifCifNie
						.isCifValido(coordinador_nuevo.getNumdoc084())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.cif.incorrecto"));
		} else if (coordinador_nuevo.getNumdoc084() != null
				&& Constantes.TIPO_NIF.equals(coordinador_nuevo.getTipdoc084())
				&& !ValidadorNifCifNie
						.isNifValido(coordinador_nuevo.getNumdoc084())) {
			errorFields.add(new ErrorField("aperturas.detalle.numDoc",
					"error.nif.incorrecto"));
		}

		if (coordinador_nuevo.getNomcrd084() == null) {
			errorFields.add(
					new ErrorField("aperturas.detalle.nombre", "error.nombre"));
		}

		if (coordinador_nuevo.getPaiscrd084() != null
				&& Constantes.ID_PAIS_ESPANA
						.equals(coordinador_nuevo.getPaiscrd084())) {
			if (coordinador_nuevo.getCodProvincia() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.provincia",
						"validacion.obligatorio"));
			}
			if (coordinador_nuevo.getCodMunicipio() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.municipio",
						"validacion.obligatorio"));
			}
		} else {
			if (coordinador_nuevo.getDmuncrd084() == null
					|| "".equals(coordinador_nuevo.getDmuncrd084())) {
				errorFields
						.add(new ErrorField("aperturas.detalle.munipExtranjero",
								"validacion.obligatorio"));
			}
		}

		if (coordinador_nuevo.getDircrd084() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.direccion",
					"error.direccion"));
		}

		if (coordinador_nuevo.getCpocrd084() == null
				|| !coordinador_nuevo.getCpocrd084().matches("[0-9]+")
				|| coordinador_nuevo.getCpocrd084()
						.length() > ConstantesNum.NUM_6) {
			errorFields.add(new ErrorField("aperturas.detalle.cp", "error.cp"));
		}

		if (coordinador_nuevo.getTlfcrd084() != null
				&& (!coordinador_nuevo.getTlfcrd084().matches("[0-9]+")
						|| coordinador_nuevo.getTlfcrd084()
								.length() > ConstantesNum.NUM_11)) {
			errorFields.add(new ErrorField("aperturas.detalle.telef",
					"error.telefono"));
		}

		return errorFields;
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterVosalanOs4Os6 VosalanOs4Os6 Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * JQGridResponseDto<VosalanOs4Os6> Dto que contiene el resultado del
	 * filtrado realizado por el componente RUP_TABLE.
	 * 
	 * @param filterVosalanOs4Os6
	 *            the filter vosalan os 4 os 6
	 * @param jqGridRequestDto
	 *            the jq grid request dto the JQ grid response dto
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/vosalanos4os6/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<VosalanOs4Os6> filter(
			@RequestJsonBody(param = "filter") VosalanOs4Os6 filterVosalanOs4Os6,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ComunicacionAperturaController.LOGGER
				.info("[POST - filter] : Obtener VosalanOs4Os6s");
		return this.vosalanOs4Os6Service.filter(filterVosalanOs4Os6,
				jqGridRequestDto, false);
	}

	/**
	 * Guardar lista aperturas sesion.
	 * 
	 * listaExp String[] model Model request HttpServletRequest String
	 * 
	 * @param listaExp
	 *            the lista exp
	 * @param model
	 *            the model
	 * @param request
	 *            the request the string
	 * @return the string
	 */
	@RequestMapping(value = "/guardarListaAperturasSesion", method = RequestMethod.POST)
	public @ResponseBody() String guardarListaAperturasSesion(
			@RequestBody() String[] listaExp, Model model,
			HttpServletRequest request) {

		List<ComunicacionApertura> listadoExpedientes = new ArrayList<ComunicacionApertura>();

		for (int i = 0; i < listaExp.length; i++) {
			String[] exp = listaExp[i].split("_");
			ComunicacionApertura apertura = new ComunicacionApertura(exp[0],
					exp[1], Long.valueOf(exp[ConstantesNum.NUM_2]));
			apertura = this.comunicAperturaService.vFind(apertura);
			listadoExpedientes.add(apertura);
		}

		HttpSession session = request.getSession();
		if (session != null) {
			session.setAttribute(
					ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_LISTA_APERTURAS,
					listadoExpedientes);
		}

		return "ok";
	}

	/**
	 * Visita osalan masiva.
	 * 
	 * model Model request HttpServletRequest String
	 * 
	 * @param model
	 *            the model
	 * @param request
	 *            the request the string
	 * @return the string
	 */
	@RequestMapping(value = "/visitaOsalanMasiva", method = RequestMethod.GET)
	public String visitaOsalanMasiva(Model model, HttpServletRequest request) {

		// Metemos la entidad Comunicación de apertura al modelo
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_DETALLE,
				new ComunicacionApertura());

		// Preparo la configuración de las opciones de tramitación
		String toolbarTramitacion = "";
		try {
			toolbarTramitacion = this.preparaToolbarVisitaMasiva();
		} catch (Exception e) {
			ComunicacionAperturaController.LOGGER.error(
					"Error al generar el toolbar de visitaOsalanMasiva", e);
			toolbarTramitacion = "{buttons: []}";
		}
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_TOOLBAR_TRAMITACION,
				toolbarTramitacion);

		HttpSession session = request.getSession();

		List<ComunicacionApertura> listadoExpedientes = new ArrayList<ComunicacionApertura>();
		if (session != null) {
			listadoExpedientes = (List<ComunicacionApertura>) session
					.getAttribute(
							ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_LISTA_APERTURAS);
		}
		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_NUM_APERTURAS,
				listadoExpedientes.size());

		return "visitaOsalanMasiva";
	}

	/**
	 * Marca la visita de Osalan en los expedientes seleccionados.
	 * 
	 * datosVisita ComunicacionApertura request HttpServletRequest Bean
	 * resultante del proceso de creacion.
	 * 
	 * @param datosVisita
	 *            the datos visita
	 * @param request
	 *            the request the string
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/marcarVisitaOsalanMasiva", method = RequestMethod.POST)
	public @ResponseBody() String marcarVisitaOsalanMasiva(
			@RequestBody() ComunicacionApertura datosVisita,
			HttpServletRequest request) throws AB04BException {
		try {
			// Validate
			List<ErrorField> errores = this.comunicacionAperturaValidator
					.validate(datosVisita, Oper.MARCAR_VISITA_OSALAN);
			if (!errores.isEmpty()) {
				throw new ErrorGenericoException(errores);
			}

			boolean marcarVisitada = datosVisita.getVisosl056()
					.equals(Constantes.ESTADO_VISITA_VISITADA);

			HttpSession session = request.getSession();

			List<ComunicacionApertura> listadoExpedientes = new ArrayList<ComunicacionApertura>();
			if (session != null) {
				listadoExpedientes = (List<ComunicacionApertura>) session
						.getAttribute(
								ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_LISTA_APERTURAS);
			}

			for (int i = 0; i < listadoExpedientes.size(); i++) {
				ComunicacionApertura apertura = listadoExpedientes.get(i);
				// comprobamos que la apertura no tiene informe de visita
				// if (apertura.getFinfosl056() == null) {

				// cargamos lista tareas del expediente
				TareaAperturas filterTarea = new TareaAperturas();
				TramiteAperturas filterTramite = new TramiteAperturas();
				filterTramite.setApertura(apertura);
				filterTarea.setTramiteAperturas(filterTramite);
				List<TareaAperturas> listaTareas = this.tareaAperturaService
						.findAllTareatramite(filterTarea, null);

				boolean crearVisita = true;
				// comprobamos que no hay tareas de un trámite de visita
				// anterior
				// pendientes de ejecutar
				for (TareaAperturas tarea : listaTareas) {
					if ((TipoTareaFlujo.ADJUNTAR_INFORME
							.esEquivalente(tarea.getTipoTarea().getTaskId090())
							|| TipoTareaFlujo.REGISTRA_INFORME_SALIDA
									.esEquivalente(
											tarea.getTipoTarea().getTaskId090())
							|| TipoTareaFlujo.REGISTRA_INFORME_ENTRADA
									.esEquivalente(tarea.getTipoTarea()
											.getTaskId090()))
							&& !EstadosTareas.EJECUTADA.getEstado()
									.equals(tarea.getEstado063())) {

						crearVisita = false;
						break;
					}
				}

				if (crearVisita) {
					apertura.setVisosl056(datosVisita.getVisosl056());
					apertura.setAsgosl056(datosVisita.getAsgosl056());
					apertura.setTecosl056(datosVisita.getTecosl056());
					apertura.setFvisosl056(datosVisita.getFvisosl056());
					this.comunicAperturaService
							.modificarDatosVisitaOsalan(apertura);
					if (marcarVisitada) {
						this.plateaTramitacionService.crearTarea(
								Utilities.getInstance()
										.obtenerProcedureIdApertura(),
								TipoTramiteFlujo.APORTAR_INFORME_VISITA.name(),
								TipoTareaFlujo.ADJUNTAR_INFORME.getTaskId(),
								apertura.getFolderId056(),
								UtilSeguridad.getInstance().getUserCredentials()
										.getPosition(),
								UtilSeguridad.getInstance().getNombre());
					}
				}

				/*
				 * if (marcarVisitada) { // Buscamos si ya existe un trámite de
				 * // APORTAR_INFORME_VISITA para el expediente Tramite tramite
				 * = this.tramiteService .findByProceedingIdProcedureId(
				 * TipoTramiteFlujo.APORTAR_INFORME_VISITA .name(),
				 * Utilities.getInstance() .obtenerProcedureIdApertura());
				 * 
				 * TramiteAperturas tramiteApertura =
				 * this.tramiteAperturaService
				 * .findLastTramiteByTipo(tramite.getIdTramite089(), apertura);
				 * // si no existe, lo creamos if (tramiteApertura == null) {
				 * 
				 * this.plateaTramitacionService.crearTarea(Utilities
				 * .getInstance().obtenerProcedureIdApertura(),
				 * TipoTramiteFlujo.APORTAR_INFORME_VISITA.name(),
				 * TipoTareaFlujo.ADJUNTAR_INFORME.getTaskId(),
				 * apertura.getFolderId056(), UtilSeguridad
				 * .getInstance().getNif(), UtilSeguridad
				 * .getInstance().getNombre()); } }
				 */
				// }
			}

			return "ok";
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Valida comunicacion apertura presencial.
	 * 
	 * errores List<ErrorField> apertura the apertura
	 * 
	 * @param errores
	 *            the errores
	 * @param apertura
	 *            the apertura
	 */
	private void validaComunicacionAperturaPresencial(List<ErrorField> errores,
			ComunicacionApertura apertura) {

		apertura.setDatosNotificacion(this.datosNotificacionService
				.findConLocalizacionYAvisos(apertura.getDatosNotificacion()));
		if (apertura.getDatosNotificacion() != null) {
			DatosAviso filterDatosAviso = new DatosAviso();
			filterDatosAviso
					.setDatosNotificacion(apertura.getDatosNotificacion());
			apertura.getDatosNotificacion().setListaDatosAviso(
					this.datosAvisoService.findAll(filterDatosAviso, null));
		}
		// DATOS NOTIFICACION
		List<ErrorField> errorTabDatosNotificacion = this.comunicacionAperturaValidator
				.validate(apertura, Oper.EDIT_TAB_NOTIFICACION);

		if (Constantes.VALUE_NO.equals(apertura.getDeseaRegistrar())) {
			if (Utilities.getInstance().isEmpty(apertura.getNumReg())) {
				errorTabDatosNotificacion.add(new ErrorField(
						"aperturas.detalle.numReg", "validacion.obligatorio"));
			}
			if (apertura.getFecReg() == null) {
				errorTabDatosNotificacion.add(new ErrorField(
						"aperturas.detalle.fecReg", "validacion.obligatorio"));
			}
		}

		if (apertura.getNumdocrepresentante056() != null) {
			if (!ValidadorNifCifNie
					.isCifValido(apertura.getNumdocrepresentante056())
					&& !ValidadorNifCifNie.isNifValido(
							apertura.getNumdocrepresentante056())) {
				errorTabDatosNotificacion.add(
						new ErrorField("aperturas.detalle.datosRepresentante",
								"error.nifcif.incorrecto"));
			}
		}
		if ((apertura.getNumdocrepresentante056() != null
				&& apertura.getNombrerepresentante056() == null)
				|| (apertura.getNumdocrepresentante056() == null
						&& apertura.getNombrerepresentante056() != null)) {
			errorTabDatosNotificacion
					.add(new ErrorField("aperturas.detalle.datosRepresentante2",
							"validacion.obligatorio"));
		}

		if (!errorTabDatosNotificacion.isEmpty()) {
			List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
			for (ErrorField error : errorTabDatosNotificacion) {
				listaMensajes.add(new Mensaje(error.getCampo()));
			}
			errores.add(
					new ErrorField("aperturas.tabs.datosNotif", listaMensajes));
		}

		// DATOS EMPRESA
		List<ErrorField> errorTabEmpresa = this.comunicacionAperturaValidator
				.validate(apertura, Oper.EDIT_TAB_DATOS_EMPRESA);
		if (!errorTabEmpresa.isEmpty()) {
			List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
			for (ErrorField error : errorTabEmpresa) {
				listaMensajes.add(new Mensaje(error.getCampo()));
			}
			errores.add(new ErrorField("aperturas.tabs.datosEmpresa",
					listaMensajes));
		}

		// DATOS CENTRO
		List<ErrorField> errorTabDatosCentro = this.comunicacionAperturaValidator
				.validate(apertura, Oper.EDIT_TAB_DATOS_CENTRO);
		if (!errorTabDatosCentro.isEmpty()) {
			List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
			for (ErrorField error : errorTabDatosCentro) {
				listaMensajes.add(new Mensaje(error.getCampo()));
			}
			errores.add(new ErrorField("aperturas.tabs.datosCentro",
					listaMensajes));
		}

		// DATOS PROD/ALMAC
		List<ErrorField> errorTabDatosProdAlmac = this.comunicacionAperturaValidator
				.validate(apertura, Oper.EDIT_TAB_PROC_ALMAC);
		if (!errorTabDatosProdAlmac.isEmpty()) {
			List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
			for (ErrorField error : errorTabDatosProdAlmac) {
				listaMensajes.add(new Mensaje(error.getCampo()));
			}
			errores.add(new ErrorField("aperturas.tabs.datosProdAlmac",
					listaMensajes));
		}

		if (Constantes.VALUE_SI.equals(apertura.getIndobra056())) {
			// DATOS OBRA
			List<ErrorField> errorTabDatosObra = this.comunicacionAperturaValidator
					.validate(apertura, Oper.EDIT_TAB_DATOS_OBRA);
			if (!errorTabDatosObra.isEmpty()) {
				List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
				for (ErrorField error : errorTabDatosObra) {
					listaMensajes.add(new Mensaje(error.getCampo()));
				}
				errores.add(new ErrorField("aperturas.tabs.datosObra",
						listaMensajes));
			}

			// COORDINADORES
			List<ErrorField> errorTabCoordinadores = this.comunicacionAperturaValidator
					.validate(apertura, Oper.EDIT_TAB_COORDINADORES);
			if (!errorTabCoordinadores.isEmpty()) {
				List<Mensaje> listaMensajes = new ArrayList<Mensaje>();
				for (ErrorField error : errorTabCoordinadores) {
					listaMensajes.add(new Mensaje(error.getCampo()));
				}
				errores.add(new ErrorField("aperturas.tabs.datosCoord",
						listaMensajes));
			}
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * terape the terape anoape the anoape numape the numape numdoc the numdoc
	 * model Model locale Locale request the request String
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param numdoc
	 *            the numdoc
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale
	 * @param request
	 *            the request the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/buscarApertura", method = RequestMethod.GET)
	public @ResponseBody() ComunicacionApertura buscarApertura(
			@RequestParam(value = "terape", required = false) String terape,
			@RequestParam(value = "anoape", required = false) String anoape,
			@RequestParam(value = "numape", required = false) String numape,
			@RequestParam(value = "numdoc", required = false) String numdoc,
			Model model, Locale locale, HttpServletRequest request) {
		try {
			ComunicacionApertura comunicAperturaFind = new ComunicacionApertura(
					terape, anoape, new Long(numape));
			comunicAperturaFind.setNumdoc056(numdoc);

			comunicAperturaFind = comunicAperturaService
					.find(comunicAperturaFind);

			return comunicAperturaFind;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale String
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale the form busqueda envio inspecc
	 * @return the form busqueda envio inspecc
	 */
	@RequestMapping(value = "/filtroEnvioInspeccion", method = RequestMethod.GET)
	public String getFormBusquedaEnvioInspecc(Model model, Locale locale) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura apertura = new ComunicacionApertura();

		Calendar c = Calendar.getInstance();
		apertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				apertura);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_VOLVER,
				false);
		model.addAttribute("envFecInspecc", Constantes.VALUE_SI);
		model.addAttribute("recFecInspecc", Constantes.VALUE_NO);
		return "comunicacionAperturaFechasInspeccion";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model locale Locale String
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale the form busqueda rec inspecc
	 * @return the form busqueda rec inspecc
	 */
	@RequestMapping(value = "/filtroEnvioRecInspeccion", method = RequestMethod.GET)
	public String getFormBusquedaRecInspecc(Model model, Locale locale) {
		ComunicacionAperturaController.LOGGER
				.info("[GET - View] : ComunicacionApertura");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);

		ComunicacionApertura apertura = new ComunicacionApertura();

		Calendar c = Calendar.getInstance();
		apertura.setAnoape056(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_FILTER,
				apertura);

		model.addAttribute(
				ComunicacionAperturaController.ATTR_NAME_COMUNICAPERTURA_VOLVER,
				false);

		model.addAttribute("recFecInspecc", Constantes.VALUE_SI);
		model.addAttribute("envFecInspecc", Constantes.VALUE_NO);

		return "comunicacionAperturaFechasInspeccion";
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * 
	 * model Model locale Locale Centro Objeto correspondiente al identificador
	 * indicado.
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale the string
	 * @return the string
	 */
	@RequestMapping(value = "/asignacionFechaInspeccion", method = RequestMethod.GET)
	public String nuevaFechaInspeccion(Model model, Locale locale) {

		ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

		model.addAttribute("fecInspeccionModel", comunicacionApertura);

		// Preparo la configuración de las opciones de la barra de botones
		model.addAttribute("fecInspeccion_toolbar",
				this.preparaToolbarFecInspeccion());
		return "fechaInspeccion";
	}

	/**
	 * Prepara los botones de anterior/guardar/siguiente para el combo de meses.
	 * 
	 * String
	 * 
	 * the string
	 * 
	 * @return the string
	 */
	private String preparaToolbarFecInspeccion() {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		botonera.addBoton(new Boton("guardar", "guardar"));
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * listado the listado comunicacionApertura the comunicacion apertura
	 * Centroj73 Bean resultante del proceso de creacion.
	 * 
	 * @param listado
	 *            the listado
	 * @param comunicacionApertura
	 *            the comunicacion apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/actualizarFechaInspeccion/{listado}", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura actualizarFechaInspeccion(
			@PathVariable() String listado,
			@RequestBody() ComunicacionApertura comunicacionApertura) {

		try {

			if (listado != null && !"".equals(listado)) {
				String[] aperturas = listado.split(",");
				for (String element : aperturas) {
					String[] idApert = element.split("~");
					String terape = idApert[0];
					String anoApe = idApert[1];
					String numApe = idApert[ConstantesNum.NUM_2];

					comunicacionApertura.setTerape056(terape);
					comunicacionApertura.setNumape056(Long.valueOf(numApe));
					comunicacionApertura.setAnoape056(anoApe);

					this.comunicAperturaService
							.updateFecInspeccion(comunicacionApertura, false);

					ComunicacionAperturaController.LOGGER.info(
							"[POST] : ComunicacionApertura Fecha inspeccion modificada correctamente");
				}
			}

		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}

		return comunicacionApertura;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * listado the listado comunicacionApertura the comunicacion apertura
	 * Centroj73 Bean resultante del proceso de creacion.
	 * 
	 * @param listado
	 *            the listado
	 * @param comunicacionApertura
	 *            the comunicacion apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/actualizarFechaRecInspeccion/{listado}", method = RequestMethod.POST)
	public @ResponseBody() ComunicacionApertura actualizarFechaRecInspeccion(
			@PathVariable() String listado,
			@RequestBody() ComunicacionApertura comunicacionApertura) {

		try {

			if (listado != null && !"".equals(listado)) {
				String[] aperturas = listado.split(",");
				for (String element : aperturas) {
					String[] idApert = element.split("~");
					String terape = idApert[0];
					String anoApe = idApert[1];
					String numApe = idApert[ConstantesNum.NUM_2];

					comunicacionApertura.setTerape056(terape);
					comunicacionApertura.setNumape056(Long.valueOf(numApe));
					comunicacionApertura.setAnoape056(anoApe);

					this.comunicAperturaService
							.updateFecInspeccion(comunicacionApertura, true);

					ComunicacionAperturaController.LOGGER.info(
							"[POST] : ComunicacionApertura Fecha recepcion inspeccion modificada correctamente");
				}
			}

		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}

		return comunicacionApertura;
	}

	/**
	 * Findlastssfromnumdoc.
	 * 
	 * apertura the apertura the comunicacion apertura
	 * 
	 * @param apertura
	 *            the apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/findlastssfromnumdoc", method = RequestMethod.POST)
	public @ResponseBody ComunicacionApertura findlastssfromnumdoc(
			@RequestBody() ComunicacionApertura apertura) {

		return this.comunicAperturaService.findLastSSofNumDoc(apertura);
	}

	/**
	 * Findlastreafromnumdoc.
	 * 
	 * apertura the apertura the comunicacion apertura
	 * 
	 * @param apertura
	 *            the apertura the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@RequestMapping(value = "/findlastreafromnumdoc", method = RequestMethod.POST)
	public @ResponseBody ComunicacionApertura findlastreafromnumdoc(
			@RequestBody() ComunicacionApertura apertura) {

		return this.comunicAperturaService.findLastREAofNumDoc(apertura);
	}

	@RequestMapping(value = "/relanzarError", method = RequestMethod.POST)
	public @ResponseBody() String relanzarError(
			@RequestParam(value = "mailbox", required = false) String mailboxTaskId,
			@RequestParam(value = "type", required = false) String taskType,
			Model model) throws Exception {

		tareaErroneaService.remove(new TareaErronea(mailboxTaskId, taskType));
		svtService.process(mailboxTaskId, taskType);

		return "ok";
	}

}
